/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGCPer;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRUPO_ANALISE_ESTOQUE_GC")
public class GrupoAnaliseEstoqueGC
implements InterfaceVO {
    private Long identificador;
    private GradeCor gradeCor;
    private Short tipoAnalise = 0;
    private Integer leadTime = 0;
    private Integer tempoCobertura = 0;
    private Double estoqueMinimo = 0.0;
    private Double estoqueRessuprimento = 0.0;
    private Double estoqueMaximo = 0.0;
    private Double fatorSeguranca = 0.0;
    private Integer diasAnalise = 0;
    private Short numeroInteiro = 0;
    private Date dataInicial;
    private Date dataFinal;
    private Double quantidadeTotal = 0.0;
    private Double mediaConsumo = 0.0;
    private GrupoAnaliseEstoque grupoAnaliseEstoque;
    private Short tipoLeadTime = 0;
    private Short informarManualmente = 0;
    private List<GrupoAnaliseEstoqueGCPer> periodos = new ArrayList<GrupoAnaliseEstoqueGCPer>();

    @Id
    @Column(name="ID_GRUPO_ANALISE_ESTOQUE_GC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_ANALISE_ESTOQUE_GC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRUPO_ANALISE_ESTOQUE_GC_GC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Column(name="TIPO_ANALISE")
    public Short getTipoAnalise() {
        return this.tipoAnalise;
    }

    public void setTipoAnalise(Short tipoAnalise) {
        this.tipoAnalise = tipoAnalise;
    }

    @Column(name="LEAD_TIME")
    public Integer getLeadTime() {
        return this.leadTime;
    }

    public void setLeadTime(Integer leadTime) {
        this.leadTime = leadTime;
    }

    @Column(name="TEMPO_COBERTURA")
    public Integer getTempoCobertura() {
        return this.tempoCobertura;
    }

    public void setTempoCobertura(Integer tempoCobertura) {
        this.tempoCobertura = tempoCobertura;
    }

    @Column(name="ESTOQUE_MINIMO", precision=15, scale=6)
    public Double getEstoqueMinimo() {
        return this.estoqueMinimo;
    }

    public void setEstoqueMinimo(Double estoqueMinimo) {
        this.estoqueMinimo = estoqueMinimo;
    }

    @Column(name="ESTOQUE_RESSUPRIMENTO", precision=15, scale=6)
    public Double getEstoqueRessuprimento() {
        return this.estoqueRessuprimento;
    }

    public void setEstoqueRessuprimento(Double estoqueRessuprimento) {
        this.estoqueRessuprimento = estoqueRessuprimento;
    }

    @Column(name="ESTOQUE_MAXIMO", precision=15, scale=6)
    public Double getEstoqueMaximo() {
        return this.estoqueMaximo;
    }

    public void setEstoqueMaximo(Double estoqueMaximo) {
        this.estoqueMaximo = estoqueMaximo;
    }

    @Column(name="DIAS_ANALISE")
    public Integer getDiasAnalise() {
        return this.diasAnalise;
    }

    public void setDiasAnalise(Integer diasAnalise) {
        this.diasAnalise = diasAnalise;
    }

    @Column(nullable=false, name="FATOR_SEGURANCA", precision=15, scale=4)
    public Double getFatorSeguranca() {
        return this.fatorSeguranca;
    }

    public void setFatorSeguranca(Double fatorSeguranca) {
        this.fatorSeguranca = fatorSeguranca;
    }

    @Column(name="NUMERO_INTEIRO")
    public Short getNumeroInteiro() {
        return this.numeroInteiro;
    }

    public void setNumeroInteiro(Short numeroInteiro) {
        this.numeroInteiro = numeroInteiro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Column(nullable=false, name="MEDIA_CONSUMO", precision=15, scale=6)
    public Double getMediaConsumo() {
        return this.mediaConsumo;
    }

    public void setMediaConsumo(Double mediaConsumo) {
        this.mediaConsumo = mediaConsumo;
    }

    @JoinColumn(name="ID_GRUPO_ANALISE_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRUPO_ANALISE_ESTOQUE_GC_GR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoAnaliseEstoque getGrupoAnaliseEstoque() {
        return this.grupoAnaliseEstoque;
    }

    public void setGrupoAnaliseEstoque(GrupoAnaliseEstoque grupoAnaliseEstoque) {
        this.grupoAnaliseEstoque = grupoAnaliseEstoque;
    }

    @Column(name="TIPO_LEAD_TIME")
    public Short getTipoLeadTime() {
        return this.tipoLeadTime;
    }

    public void setTipoLeadTime(Short tipoLeadTime) {
        this.tipoLeadTime = tipoLeadTime;
    }

    @Column(name="INFORMAR_MANUALMENTE")
    public Short getInformarManualmente() {
        return this.informarManualmente;
    }

    public void setInformarManualmente(Short informarManualmente) {
        this.informarManualmente = informarManualmente;
    }

    @OneToMany(mappedBy="grupoAnaliseEstoqueGC")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<GrupoAnaliseEstoqueGCPer> getPeriodos() {
        return this.periodos;
    }

    public void setPeriodos(List<GrupoAnaliseEstoqueGCPer> periodos) {
        this.periodos = periodos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

