/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoAtendPedidoAlmoxPreFatTransf;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRUPO_ATEND_PEDIDO_ALMOX")
public class GrupoAtendPedidoAlmox
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataInicial;
    private Date dataFinal;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Usuario usuario;
    private String observacao;
    private Date dataAtendimento;
    private List<GrupoAtendPedidoAlmoxPreFatTransf> grupoAtendPedPreFatNF;
    private List<AtendPedidoAlmox> atendimentosPedAlmox = new ArrayList<AtendPedidoAlmox>();
    private PreFaturamentoNF preFaturamentoNF;

    public GrupoAtendPedidoAlmox() {
        this.grupoAtendPedPreFatNF = new ArrayList<GrupoAtendPedidoAlmoxPreFatTransf>();
    }

    @Id
    @Column(nullable=false, name="ID_GRUPO_ATEND_PEDIDO_ALMOX")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_ATEND_PEDIDO_ALMOX")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_ATEND_PEDIDO_ALMOX_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_GRUPO_ATEND_PEDIDO_ALMOX_USU"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="grupoAtendPedidoAlmox")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AtendPedidoAlmox> getAtendimentosPedAlmox() {
        return this.atendimentosPedAlmox;
    }

    public void setAtendimentosPedAlmox(List<AtendPedidoAlmox> atendimentosPedAlmox) {
        this.atendimentosPedAlmox = atendimentosPedAlmox;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataIn) {
        this.dataInicial = dataIn;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String toString() {
        Object ret1 = "";
        String ret2 = "";
        if (this.getDataCadastro() != null) {
            ret1 = " Atendimento: " + ToolDate.dateToStr((Date)this.getDataCadastro());
        }
        if (this.getObservacao() != null) {
            ret2 = this.getObservacao();
        }
        if (!"".equals(ret1) && ret2.equals("")) {
            return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getIdentificador(), ret1});
        }
        if (((String)ret1).equals("") && !"".equals(ret2)) {
            return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getIdentificador(), ret2});
        }
        if (!"".equals(ret1) & !"".equals(ret2)) {
            return ToolBaseMethodsVO.toString((String)"{0}-{1}-{2}", (Object[])new Object[]{this.getIdentificador(), ret1, ret2});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_ATENDIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAtendimento() {
        return this.dataAtendimento;
    }

    public void setDataAtendimento(Date dataAtendimento) {
        this.dataAtendimento = dataAtendimento;
    }

    @OneToMany(mappedBy="grupoAtendPedidoAlmox")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<GrupoAtendPedidoAlmoxPreFatTransf> getGrupoAtendPedPreFatNF() {
        return this.grupoAtendPedPreFatNF;
    }

    public void setGrupoAtendPedPreFatNF(List<GrupoAtendPedidoAlmoxPreFatTransf> grupoAtendPedPreFatNF) {
        this.grupoAtendPedPreFatNF = grupoAtendPedPreFatNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_FATURAMENTO_NF", foreignKey=@ForeignKey(name="FK_GRUPO_ATEND_PED_ALMOX_PRE_FA"))
    public PreFaturamentoNF getPreFaturamentoNF() {
        return this.preFaturamentoNF;
    }

    public void setPreFaturamentoNF(PreFaturamentoNF preFaturamentoNF) {
        this.preFaturamentoNF = preFaturamentoNF;
    }
}

