/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRUPO_COMPENSACAO")
public class GrupoCompensacao
implements InterfaceVO {
    private Long identificador;
    private List<CompensacaoCheque> compensacaoCheques = new ArrayList<CompensacaoCheque>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private ModeloLancBancario modeloLancBancario;
    private HistoricoPadrao historico;
    private String descricaoHistorico;
    private ContaValores contaValor;

    @Id
    @Column(nullable=false, name="ID_GRUPO_COMPENSACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_COMPENSACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="grupoCompensacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CompensacaoCheque> getCompensacaoCheques() {
        return this.compensacaoCheques;
    }

    public void setCompensacaoCheques(List<CompensacaoCheque> compensacaoCheques) {
        this.compensacaoCheques = compensacaoCheques;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_COMPENSACAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_LANC_BANCARIO", foreignKey=@ForeignKey(name="FK_GRUPO_COMPENSACAO_M_BANCA"))
    public ModeloLancBancario getModeloLancBancario() {
        return this.modeloLancBancario;
    }

    public void setModeloLancBancario(ModeloLancBancario modeloLancBancario) {
        this.modeloLancBancario = modeloLancBancario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO", foreignKey=@ForeignKey(name="FK_GRUPO_COMPENSACAO_HISTORICO"))
    public HistoricoPadrao getHistorico() {
        return this.historico;
    }

    public void setHistorico(HistoricoPadrao historico) {
        this.historico = historico;
    }

    @Column(name="DESC_HISTORICO", length=1000)
    public String getDescricaoHistorico() {
        return this.descricaoHistorico;
    }

    public void setDescricaoHistorico(String descricaoHistorico) {
        this.descricaoHistorico = descricaoHistorico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_GRUPO_COMPENSACAO_CONTA_VALOR"))
    public ContaValores getContaValor() {
        return this.contaValor;
    }

    public void setContaValor(ContaValores contaValor) {
        this.contaValor = contaValor;
    }
}

