/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.inject.InjectActualCompany;
import com.touchcomp.basementor.annotations.inject.InjectActualDate;
import com.touchcomp.basementor.annotations.inject.InjectActualUser;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="GR_LIB_ORDEM_COMPRA_ITEM")
public class GrupoLiberacaoOrdemCompraItem
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private List<LiberacaoOrdemCompraItem> itens = new LinkedList<LiberacaoOrdemCompraItem>();
    private Usuario usuario;
    private Empresa empresa;

    public GrupoLiberacaoOrdemCompraItem() {
        this.dataCadastro = new Date();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_GR_LIB_ORDEM_COMPRA_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GR_LIB_ORDEM_COMPRA_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @InjectActualDate
    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="grupoLibOrdemCompraItem", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<LiberacaoOrdemCompraItem> getItens() {
        return this.itens;
    }

    public void setItens(List<LiberacaoOrdemCompraItem> itens) {
        this.itens = itens;
    }

    @InjectActualUser
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_GR_LIB_ORDEM_C_ITEM_USU"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @InjectActualCompany
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GR_LIB_ORDEM_C_ITEM_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}/{1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.dataCadastro)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

