/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRUPO_NEC_COMPRA")
public class GrupoNecCompra
implements InterfaceVO {
    private Long identificador;
    private List<NecessidadeCompra> necessidadesCompra = new ArrayList<NecessidadeCompra>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short tipoNecessidade = 0;
    private Usuario usuarioSolicitante;
    private Usuario usuarioComprador;
    private Usuario usuarioLiberacao;
    private Empresa empresa;
    private CentroCusto centroCusto;
    private String observacao;
    private List<EmailGrupoNecCompra> emailGrupoNecCompra = new ArrayList<EmailGrupoNecCompra>();
    private Equipamento ativo;

    @Id
    @Column(name="ID_GRUPO_NEC_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_NEC_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="grupoNecCompra")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NecessidadeCompra> getNecessidadesCompra() {
        return this.necessidadesCompra;
    }

    public void setNecessidadesCompra(List<NecessidadeCompra> necessidadesCompra) {
        this.necessidadesCompra = necessidadesCompra;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="TIPO_NECESSIDADE")
    public Short getTipoNecessidade() {
        return this.tipoNecessidade;
    }

    public void setTipoNecessidade(Short tipoNecessidade) {
        this.tipoNecessidade = tipoNecessidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_SOLICITANTE", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_USU_SOL"))
    public Usuario getUsuarioSolicitante() {
        return this.usuarioSolicitante;
    }

    public void setUsuarioSolicitante(Usuario usuarioSolicitante) {
        this.usuarioSolicitante = usuarioSolicitante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_COMPRADOR", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_USU_COMP"))
    public Usuario getUsuarioComprador() {
        return this.usuarioComprador;
    }

    public void setUsuarioComprador(Usuario usuarioComprador) {
        this.usuarioComprador = usuarioComprador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_LIBERACAO", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_USU_LIBE"))
    public Usuario getUsuarioLiberacao() {
        return this.usuarioLiberacao;
    }

    public void setUsuarioLiberacao(Usuario usuarioLiberacao) {
        this.usuarioLiberacao = usuarioLiberacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_CENT_CUST"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="grupoNecCompra", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EmailGrupoNecCompra> getEmailGrupoNecCompra() {
        return this.emailGrupoNecCompra;
    }

    public void setEmailGrupoNecCompra(List<EmailGrupoNecCompra> emailGrupoNecCompra) {
        this.emailGrupoNecCompra = emailGrupoNecCompra;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Grupo Necessidade de compra numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_GRUPO_NEC_COMPRA_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }
}

