/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BandeiraCartaoNFe;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INF_PAG_PEDIDO")
public class InfPagamentoPedido
implements InterfaceVO {
    private Long identificador;
    private MeioPagamento meioPagamento;
    private Double valor = 0.0;
    private String nrAutorizacao;
    private Pedido pedido;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private TipoPagamentoNFe tipoPagamentoNFe;
    private BandeiraCartaoNFe bandeiraCartaoNFe;
    private Pessoa credenciadoraCreditoDebito;
    private Short tipoIntegracao = 1;
    private CondicoesPagamento condicoesPagamento;
    private Double valorAcrescimo = 0.0;
    private Double valorDesconto = 0.0;
    private int nrDiasMedios = 0;
    private String parcelas;
    private Double valorTroco = 0.0;
    private Double valorLiquido = 0.0;
    private Short naoGerarComissao = 0;
    private Short tipoPagST = 0;
    private Date dataFinanceiraCartao;

    @Id
    @Column(nullable=false, name="ID_INF_PAG_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INF_PAG_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_MEIO_PAG"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(nullable=true, name="NR_AUTORIZACAO", length=20)
    public String getNrAutorizacao() {
        return this.nrAutorizacao;
    }

    public void setNrAutorizacao(String nrAutorizacao) {
        this.nrAutorizacao = nrAutorizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @OneToMany(mappedBy="infPagamentoPedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPedido() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPedido().getIdentificador()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_NFE", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_TIPO_PAG_NFE"))
    public TipoPagamentoNFe getTipoPagamentoNFe() {
        return this.tipoPagamentoNFe;
    }

    public void setTipoPagamentoNFe(TipoPagamentoNFe tipoPagamentoNFe) {
        this.tipoPagamentoNFe = tipoPagamentoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BANDEIRA_CARTAO_NFE", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_BAND_CARTAO"))
    public BandeiraCartaoNFe getBandeiraCartaoNFe() {
        return this.bandeiraCartaoNFe;
    }

    public void setBandeiraCartaoNFe(BandeiraCartaoNFe bandeiraCartaoNFe) {
        this.bandeiraCartaoNFe = bandeiraCartaoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CREDENCIADORA_CRED_DEB", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_CRED_CARTAO"))
    public Pessoa getCredenciadoraCreditoDebito() {
        return this.credenciadoraCreditoDebito;
    }

    public void setCredenciadoraCreditoDebito(Pessoa credenciadoraCreditoDebito) {
        this.credenciadoraCreditoDebito = credenciadoraCreditoDebito;
    }

    @Column(name="TIPO_INTEGRACAO")
    public Short getTipoIntegracao() {
        return this.tipoIntegracao;
    }

    public void setTipoIntegracao(Short tipoIntegracao) {
        this.tipoIntegracao = tipoIntegracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_INF_PAG_PEDIDO_COND_PAGAMENT"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(nullable=false, name="VALOR_ACRESCIMO", precision=15, scale=2)
    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public void setValorAcrescimo(Double valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(nullable=false, name="NR_DIAS_MEDIOS")
    public int getNrDiasMedios() {
        return this.nrDiasMedios;
    }

    public void setNrDiasMedios(int nrDiasMedios) {
        this.nrDiasMedios = nrDiasMedios;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @Column(name="VALOR_TROCO", precision=15, scale=2)
    public Double getValorTroco() {
        return this.valorTroco;
    }

    public void setValorTroco(Double valorTroco) {
        this.valorTroco = valorTroco;
    }

    @Column(name="VALOR_LIQUIDO", precision=15, scale=2)
    public Double getValorLiquido() {
        return this.valorLiquido;
    }

    public void setValorLiquido(Double valorLiquido) {
        this.valorLiquido = valorLiquido;
    }

    @Column(name="NAO_GERAR_COMISSAO")
    public Short getNaoGerarComissao() {
        return this.naoGerarComissao;
    }

    public void setNaoGerarComissao(Short naoGerarComissao) {
        this.naoGerarComissao = naoGerarComissao;
    }

    @Column(name="TIPO_PAG_ST")
    public Short getTipoPagST() {
        return this.tipoPagST;
    }

    public void setTipoPagST(Short tipoPagST) {
        this.tipoPagST = tipoPagST;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_financeira_cartao")
    public Date getDataFinanceiraCartao() {
        return this.dataFinanceiraCartao;
    }

    public void setDataFinanceiraCartao(Date dataFinanceiraCartao) {
        this.dataFinanceiraCartao = dataFinanceiraCartao;
    }
}

