/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.integracaocomunicadoprod.ConstEnumIntegracaoComunicadoProd;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnaliseCustoProd;
import com.touchcomp.basementor.model.vo.BloqueioAlteracaoEstoque;
import com.touchcomp.basementor.model.vo.BloqueioComProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegComuProdEspecie;
import com.touchcomp.basementor.model.vo.IntegComuProdSubEspecie;
import com.touchcomp.basementor.model.vo.IntegracaoComProducaoItem;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INTEGRACAO_COM_PRODUCAO")
public class IntegracaoComunicadoProducao
implements InterfaceVO {
    private Long identificador;
    private BloqueioComProducao bloqueioComProducao;
    private BloqueioAlteracaoEstoque bloqueioAlteracaoEstoque;
    private Date dataInicial;
    private Date dataFinal;
    private Empresa empresa;
    private Short gerarLancCentroCusto = 0;
    private Short gerarLancContabil = 0;
    private Short gerarLancGerencial = 0;
    private Short tipoIntegracao;
    private AnaliseCustoProd analiseCustoProducao;
    private LoteContabil loteTransferenciaCustos;
    private List<IntegracaoComProducaoItem> itensLotesContabeisDia = new LinkedList<IntegracaoComProducaoItem>();
    private Short atualizarPlanoConta;
    private Short gerarLancAnalitico;
    private Short desconsiderarComunicadosDeValorZerados;
    private List<IntegComuProdSubEspecie> subespecies;
    private List<IntegComuProdEspecie> especies;

    public IntegracaoComunicadoProducao() {
        this.tipoIntegracao = ConstEnumIntegracaoComunicadoProd.INTEGRACAO_NORMAL.value;
        this.atualizarPlanoConta = 0;
        this.gerarLancAnalitico = 0;
        this.desconsiderarComunicadosDeValorZerados = 0;
        this.setSubespecies(new ArrayList<IntegComuProdSubEspecie>());
        this.setEspecies(new ArrayList<IntegComuProdEspecie>());
    }

    @Id
    @Column(name="ID_INTEGRACAO_COM_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INTEGRACAO_COM_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_BLOQUEIO_COM_PRODUCAO", foreignKey=@ForeignKey(name="FK_INTEG_COM_PRODUCAO_BLOQUEIO"))
    public BloqueioComProducao getBloqueioComProducao() {
        return this.bloqueioComProducao;
    }

    public void setBloqueioComProducao(BloqueioComProducao bloqueioComProducao) {
        this.bloqueioComProducao = bloqueioComProducao;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_BLOQUEIO_ALT_ESTOQUE", foreignKey=@ForeignKey(name="FK_INTEG_COM_PRODUCAO_ALT_ESTOQ"))
    public BloqueioAlteracaoEstoque getBloqueioAlteracaoEstoque() {
        return this.bloqueioAlteracaoEstoque;
    }

    public void setBloqueioAlteracaoEstoque(BloqueioAlteracaoEstoque bloqueioAlteracaoEstoque) {
        this.bloqueioAlteracaoEstoque = bloqueioAlteracaoEstoque;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INTEG_COM_PRODUCAO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1} - {2}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.dataInicial), ToolDate.dateToStr((Date)this.dataFinal)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="GERAR_LANC_CENTRO_CUSTO")
    public Short getGerarLancCentroCusto() {
        return this.gerarLancCentroCusto;
    }

    public void setGerarLancCentroCusto(Short gerarLancCentroCusto) {
        this.gerarLancCentroCusto = gerarLancCentroCusto;
    }

    @Column(name="GERAR_LANC_CONTABIL")
    public Short getGerarLancContabil() {
        return this.gerarLancContabil;
    }

    public void setGerarLancContabil(Short gerarLancContabil) {
        this.gerarLancContabil = gerarLancContabil;
    }

    @Column(name="GERAR_LANC_GERENCIAL")
    public Short getGerarLancGerencial() {
        return this.gerarLancGerencial;
    }

    public void setGerarLancGerencial(Short gerarLancGerencial) {
        this.gerarLancGerencial = gerarLancGerencial;
    }

    @Column(name="TIPO_INTEGRACAO")
    public Short getTipoIntegracao() {
        return this.tipoIntegracao;
    }

    public void setTipoIntegracao(Short tipoIntegracao) {
        this.tipoIntegracao = tipoIntegracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ANALISE_CUSTO_PROD", foreignKey=@ForeignKey(name="FK_INTEG_COM_PRODUCAO_ANAL_C_PR"))
    public AnaliseCustoProd getAnaliseCustoProducao() {
        return this.analiseCustoProducao;
    }

    public void setAnaliseCustoProducao(AnaliseCustoProd analiseCustoProducao) {
        this.analiseCustoProducao = analiseCustoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_TRANSF_CUSTOS", foreignKey=@ForeignKey(name="FK_INTEG_COM_PRODUCAO_LT_TRANSF"))
    public LoteContabil getLoteTransferenciaCustos() {
        return this.loteTransferenciaCustos;
    }

    public void setLoteTransferenciaCustos(LoteContabil loteTransferenciaCustos) {
        this.loteTransferenciaCustos = loteTransferenciaCustos;
    }

    @OneToMany(mappedBy="integracaoComunicadoProd", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<IntegracaoComProducaoItem> getItensLotesContabeisDia() {
        return this.itensLotesContabeisDia;
    }

    public void setItensLotesContabeisDia(List<IntegracaoComProducaoItem> itensLotesContabeisDia) {
        this.itensLotesContabeisDia = itensLotesContabeisDia;
    }

    @Column(name="ATUALIZAR_PLANO_CONTA")
    public Short getAtualizarPlanoConta() {
        return this.atualizarPlanoConta;
    }

    public void setAtualizarPlanoConta(Short atualizarPlanoConta) {
        this.atualizarPlanoConta = atualizarPlanoConta;
    }

    @Column(name="GERAR_LANC_ANALITICO")
    public Short getGerarLancAnalitico() {
        return this.gerarLancAnalitico;
    }

    public void setGerarLancAnalitico(Short gerarLancAnalitico) {
        this.gerarLancAnalitico = gerarLancAnalitico;
    }

    @Column(name="DESCONSIDERAR_COMUCA_VAL_ZERO")
    public Short getDesconsiderarComunicadosDeValorZerados() {
        return this.desconsiderarComunicadosDeValorZerados;
    }

    public void setDesconsiderarComunicadosDeValorZerados(Short desconsiderarComunicadosDeValorZerados) {
        this.desconsiderarComunicadosDeValorZerados = desconsiderarComunicadosDeValorZerados;
    }

    @OneToMany(mappedBy="integracaoComunicadoProducao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegComuProdSubEspecie> getSubespecies() {
        return this.subespecies;
    }

    public void setSubespecies(List<IntegComuProdSubEspecie> subespecies) {
        this.subespecies = subespecies;
    }

    @OneToMany(mappedBy="integracaoComunicadoProducao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegComuProdEspecie> getEspecies() {
        return this.especies;
    }

    public void setEspecies(List<IntegComuProdEspecie> especies) {
        this.especies = especies;
    }
}

