/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.analisecustoprod.EnumAnaCustoTipoProcDevolucoes;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BloqueioAlteracaoEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INTEGRACAO_CUSTO_PR_VENDIDO")
public class IntegracaoCustoProdVendido
implements InterfaceVO {
    private Long identificador;
    private BloqueioAlteracaoEstoque bloqueioAlteracaoEstoque;
    private List<IntegCustoProdVendidoData> itemIntegCustoProdVendData = new ArrayList<IntegCustoProdVendidoData>();
    private Date dataInicial;
    private Date dataFinal;
    private Empresa empresa;
    private Short gerarContabil = 0;
    private Short gerarGerencial = 0;
    private Short gerarLancAnalitico = 0;
    private Short tipoProcDevolucoes = EnumAnaCustoTipoProcDevolucoes.NAO_REPROCESSAR.getValue();

    @Id
    @Column(name="ID_INTEGRACAO_CUSTO_PR_VENDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INT_CUSTO_PR_VENDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_BLOQUEIO_ALT_ESTOQUE", foreignKey=@ForeignKey(name="FK_INT_CUSTO_PR_VENDIDO_BLOQUEI"))
    public BloqueioAlteracaoEstoque getBloqueioAlteracaoEstoque() {
        return this.bloqueioAlteracaoEstoque;
    }

    public void setBloqueioAlteracaoEstoque(BloqueioAlteracaoEstoque bloqueioAlteracaoEstoque) {
        this.bloqueioAlteracaoEstoque = bloqueioAlteracaoEstoque;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INT_CUSTO_PR_VENDIDO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1} - {2}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.dataInicial), ToolDate.dateToStr((Date)this.dataFinal)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="integracaoCustoProdVendido")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegCustoProdVendidoData> getItemIntegCustoProdVendData() {
        return this.itemIntegCustoProdVendData;
    }

    public void setItemIntegCustoProdVendData(List<IntegCustoProdVendidoData> itemIntegCustoProdVendData) {
        this.itemIntegCustoProdVendData = itemIntegCustoProdVendData;
    }

    @Column(name="GERAR_CONTABIL")
    public Short getGerarContabil() {
        return this.gerarContabil;
    }

    public void setGerarContabil(Short gerarContabil) {
        this.gerarContabil = gerarContabil;
    }

    @Column(name="GERAR_GERENCIAL")
    public Short getGerarGerencial() {
        return this.gerarGerencial;
    }

    public void setGerarGerencial(Short gerarGerencial) {
        this.gerarGerencial = gerarGerencial;
    }

    @Column(name="GERAR_LANC_ANALITICO")
    public Short getGerarLancAnalitico() {
        return this.gerarLancAnalitico;
    }

    public void setGerarLancAnalitico(Short gerarLancAnalitico) {
        this.gerarLancAnalitico = gerarLancAnalitico;
    }

    @Column(name="TIPO_PROC_DEVOLUCOES")
    public Short getTipoProcDevolucoes() {
        return this.tipoProcDevolucoes;
    }

    public void setTipoProcDevolucoes(Short tipoProcDevolucoes) {
        this.tipoProcDevolucoes = tipoProcDevolucoes;
    }
}

