/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.TipoEmissaoCTe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="INUTILIZACAO_NUM_CTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_INUTILIZACAO_NUM_CTE", columnNames={"CHAVE_ID"})})
public class InutilizacaoNumeracaoCTe
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String chaveID;
    private Date periodo;
    private ModeloDocFiscal modeloDocFiscal;
    private Long numeroInicial;
    private Long numeroFinal = this.numeroInicial = Long.valueOf(0L);
    private String justificativa;
    private Integer serie = 0;
    private String status;
    private String motivo;
    private String numProtocolo;
    private Short enviado = 0;
    private String conteudoInutilizacao;
    private String conteudoEnviado;
    private TipoEmissaoCTe tipoEmissaoCTe;

    @Id
    @Column(name="ID_INUTILIZACAO_NUM_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INUTILIZACAO_NUM_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CHAVE_ID", length=41)
    public String getChaveID() {
        return this.chaveID;
    }

    public void setChaveID(String chaveID) {
        this.chaveID = chaveID;
    }

    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_CTE_MOD_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="NUMERO_INICIAL")
    public Long getNumeroInicial() {
        return this.numeroInicial;
    }

    public void setNumeroInicial(Long numeroInicial) {
        this.numeroInicial = numeroInicial;
    }

    @Column(name="NUMERO_FINAL")
    public Long getNumeroFinal() {
        return this.numeroFinal;
    }

    public void setNumeroFinal(Long numeroFinal) {
        this.numeroFinal = numeroFinal;
    }

    @Column(name="JUSTIFICATIVA", length=255)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Column(name="SERIE")
    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer serie) {
        this.serie = serie;
    }

    @Column(name="STATUS", length=3)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Column(name="NUM_PROTOCOLO", length=15)
    public String getNumProtocolo() {
        return this.numProtocolo;
    }

    public void setNumProtocolo(String numProtocolo) {
        this.numProtocolo = numProtocolo;
    }

    @Column(name="ENVIADO")
    public Short getEnviado() {
        return this.enviado;
    }

    public void setEnviado(Short enviado) {
        this.enviado = enviado;
    }

    @Column(name="CONTEUDO_INUTILIZACAO")
    public String getConteudoInutilizacao() {
        return this.conteudoInutilizacao;
    }

    public void setConteudoInutilizacao(String conteudoInutilizacao) {
        this.conteudoInutilizacao = conteudoInutilizacao;
    }

    @Column(name="CONTEUDO_ENVIADO")
    public String getConteudoEnviado() {
        return this.conteudoEnviado;
    }

    public void setConteudoEnviado(String conteudoEnviado) {
        this.conteudoEnviado = conteudoEnviado;
    }

    @Column(name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_TIPO_EMISSAO_CTE", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_CTE_TP_EM_C"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEmissaoCTe getTipoEmissaoCTe() {
        return this.tipoEmissaoCTe;
    }

    public void setTipoEmissaoCTe(TipoEmissaoCTe tipoEmissaoCTe) {
        this.tipoEmissaoCTe = tipoEmissaoCTe;
    }
}

