/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="INUTILIZACAO_NUM_NFE")
public class InutilizacaoNumeracaoNFe
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String chaveID;
    private Date periodo;
    private ModeloDocFiscal modeloDocFiscal;
    private Integer numeroInicial = 0;
    private Integer numeroFinal = 0;
    private String justificativa;
    private String serie;
    private String status;
    private String motivo;
    private String numProtocolo;
    private Short enviado = 0;
    private Short naoEnviarNotaSefaz = 0;
    private Integer tipoInutilizacao = 0;
    private byte[] conteudoInutilizacao;
    private byte[] conteudoEnviado;
    private TipoEmissaoNFe tipoEmissaoNFe;
    private String serialForSinc;
    private NFCe nfce;
    private NotaFiscalPropria notaFiscalPropria;
    private NFCeControleCaixa nfceControleCaixa;

    @Id
    @Column(name="ID_INUTILIZACAO_NUM_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INUTILIZACAO_NUM_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CHAVE_ID", length=44)
    public String getChaveID() {
        return this.chaveID;
    }

    public void setChaveID(String chaveID) {
        this.chaveID = chaveID;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_MOD_F"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="NUMERO_INICIAL")
    public Integer getNumeroInicial() {
        return this.numeroInicial;
    }

    public void setNumeroInicial(Integer numeroInicial) {
        this.numeroInicial = numeroInicial;
    }

    @Column(name="NUMERO_FINAL")
    public Integer getNumeroFinal() {
        return this.numeroFinal;
    }

    public void setNumeroFinal(Integer numeroFinal) {
        this.numeroFinal = numeroFinal;
    }

    @Column(name="JUSTIFICATIVA", length=255)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="STATUS", length=4)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Column(name="NUM_PROTOCOLO", length=15)
    public String getNumProtocolo() {
        return this.numProtocolo;
    }

    public void setNumProtocolo(String numProtocolo) {
        this.numProtocolo = numProtocolo;
    }

    @Column(name="ENVIADO")
    public Short getEnviado() {
        return this.enviado;
    }

    public void setEnviado(Short enviado) {
        this.enviado = enviado;
    }

    @Column(name="CONTEUDO_INUTILIZACAO")
    public byte[] getConteudoInutilizacao() {
        return this.conteudoInutilizacao;
    }

    public void setConteudoInutilizacao(byte[] conteudoInutilizacao) {
        this.conteudoInutilizacao = conteudoInutilizacao;
    }

    @Column(name="CONTEUDO_ENVIADO")
    public byte[] getConteudoEnviado() {
        return this.conteudoEnviado;
    }

    public void setConteudoEnviado(byte[] conteudoEnviado) {
        this.conteudoEnviado = conteudoEnviado;
    }

    @Column(name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(name="TIPO_INUTILIZACAO")
    public Integer getTipoInutilizacao() {
        return this.tipoInutilizacao;
    }

    public void setTipoInutilizacao(Integer tipoInutilizacao) {
        this.tipoInutilizacao = tipoInutilizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_TP_EM_N"))
    public TipoEmissaoNFe getTipoEmissaoNFe() {
        return this.tipoEmissaoNFe;
    }

    public void setTipoEmissaoNFe(TipoEmissaoNFe tipoEmissaoNFe) {
        this.tipoEmissaoNFe = tipoEmissaoNFe;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getJustificativa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NAO_ENVIAR_NOTA_SEFAZ")
    public Short getNaoEnviarNotaSefaz() {
        return this.naoEnviarNotaSefaz;
    }

    public void setNaoEnviarNotaSefaz(Short naoEnviarNotaSefaz) {
        this.naoEnviarNotaSefaz = naoEnviarNotaSefaz;
    }

    @Column(name="SERIAL_FOR_SINC", length=50)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinColumn(name="ID_NFCE", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_NFCE"))
    public NFCe getNfce() {
        return this.nfce;
    }

    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_NF_PR"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CONTROLE_CAIXA", foreignKey=@ForeignKey(name="FK_INUTILIZACAO_NUM_NFE_CON_CAI"))
    public NFCeControleCaixa getNfceControleCaixa() {
        return this.nfceControleCaixa;
    }

    public void setNfceControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        this.nfceControleCaixa = nfceControleCaixa;
    }
}

