/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsTipoCobrancaApuracao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ItemTituloApuracCooperado;
import com.touchcomp.basementor.model.vo.LancComissaoApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_APURACAO_VALORES_COOPERADO")
public class ItemApuracaoValoresCooperados
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Double valor = 0.0;
    private String codigoBanco;
    private String codigoAgencia;
    private String digitoVerificadorAgencia;
    private String codigoContaBancaria;
    private String digitoVerificadorConta;
    private String codigoCompensacaoBancaria;
    private ApuracaoValoresCooperados apuracaoValoresCooperado;
    private List<ItemTituloApuracCooperado> titulos = new ArrayList<ItemTituloApuracCooperado>();
    private Titulo tituloMesSeguinte;
    private Short tipoCobrancaApuracao = ConstantsTipoCobrancaApuracao.NAO_GERAR_TITULO;
    private Short boletoGerado = 0;
    private Short debitoContaGerado = 0;
    private Cliente cliente;
    private List<LancComissaoApuracaoValoresCooperados> lancamentosComissao = new ArrayList<LancComissaoApuracaoValoresCooperados>();

    @Id
    @Column(nullable=false, name="ID_ITEM_APURACAO_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_APURACAO_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ITEM_APURACAO_VALORES_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="CODIGO_BANCO", length=10)
    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    @Column(name="CODIGO_AGENCIA", length=10)
    public String getCodigoAgencia() {
        return this.codigoAgencia;
    }

    public void setCodigoAgencia(String codigoAgencia) {
        this.codigoAgencia = codigoAgencia;
    }

    @Column(name="DIGITO_VERIFICADOR_AGENCIA", length=10)
    public String getDigitoVerificadorAgencia() {
        return this.digitoVerificadorAgencia;
    }

    public void setDigitoVerificadorAgencia(String digitoVerificadorAgencia) {
        this.digitoVerificadorAgencia = digitoVerificadorAgencia;
    }

    @Column(name="CODIGO_CONTA_BANCARIA", length=10)
    public String getCodigoContaBancaria() {
        return this.codigoContaBancaria;
    }

    public void setCodigoContaBancaria(String codigoContaBancaria) {
        this.codigoContaBancaria = codigoContaBancaria;
    }

    @Column(name="DIGITO_VERIFICADOR_CONTA", length=10)
    public String getDigitoVerificadorConta() {
        return this.digitoVerificadorConta;
    }

    public void setDigitoVerificadorConta(String digitoVerificadorConta) {
        this.digitoVerificadorConta = digitoVerificadorConta;
    }

    @Column(name="CODIGO_COMPENSACAO_BANCARIA", length=10)
    public String getCodigoCompensacaoBancaria() {
        return this.codigoCompensacaoBancaria;
    }

    public void setCodigoCompensacaoBancaria(String codigoCompensacaoBancaria) {
        this.codigoCompensacaoBancaria = codigoCompensacaoBancaria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_VALORES_COOPERADO", foreignKey=@ForeignKey(name="FK_ITEM_APURACAO_VALORES_COOPER"))
    public ApuracaoValoresCooperados getApuracaoValoresCooperado() {
        return this.apuracaoValoresCooperado;
    }

    public void setApuracaoValoresCooperado(ApuracaoValoresCooperados apuracaoValoresCooperado) {
        this.apuracaoValoresCooperado = apuracaoValoresCooperado;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemApuracaoCooperado", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemTituloApuracCooperado> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<ItemTituloApuracCooperado> titulos) {
        this.titulos = titulos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_TITULO_MES_SEGUINTE", foreignKey=@ForeignKey(name="FK_ITEM_APURACAO_VALORES_TITULO"))
    public Titulo getTituloMesSeguinte() {
        return this.tituloMesSeguinte;
    }

    public void setTituloMesSeguinte(Titulo tituloMesSeguinte) {
        this.tituloMesSeguinte = tituloMesSeguinte;
    }

    @Column(name="TIPO_COBRANCA_APURACAO")
    public Short getTipoCobrancaApuracao() {
        return this.tipoCobrancaApuracao;
    }

    public void setTipoCobrancaApuracao(Short tipoCobrancaApuracao) {
        this.tipoCobrancaApuracao = tipoCobrancaApuracao;
    }

    @Column(name="BOLETO_GERADO")
    public Short getBoletoGerado() {
        return this.boletoGerado;
    }

    public void setBoletoGerado(Short boletoGerado) {
        this.boletoGerado = boletoGerado;
    }

    @Column(name="DEBITO_CONTA_GERADO")
    public Short getDebitoContaGerado() {
        return this.debitoContaGerado;
    }

    public void setDebitoContaGerado(Short debitoContaGerado) {
        this.debitoContaGerado = debitoContaGerado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_ITEM_AP_VAL_COOP_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemApuracaoValoresCooperados", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<LancComissaoApuracaoValoresCooperados> getLancamentosComissao() {
        return this.lancamentosComissao;
    }

    public void setLancamentosComissao(List<LancComissaoApuracaoValoresCooperados> lancamentosComissao) {
        this.lancamentosComissao = lancamentosComissao;
    }
}

