/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="ITEM_COMPOSICAO_CUSTO")
public class ItemComposicaoCusto
implements InterfaceVO {
    private Long identificador;
    private FaseProdutiva faseProdutiva;
    private GradeCor gradeCor;
    private ItemComunicadoProducao itemComProducao;
    private Double valorInicial = 0.0;
    private Double valorReal = 0.0;
    private Colaborador colaborador;
    private Date dataReferencia;
    private Double quantidadeRef = 0.0;
    private CentroEstoque centroEstoque;
    private Double precoMedio = 0.0;
    private ItemComProdOutrosCustos itemOutrosCustos;
    private Empresa empresa;
    private Produto produto;
    private Short flagProcessamentoCusto = 0;

    @Id
    @Column(name="ID_ITEM_COMPOSICAO_CUSTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_COMPOSICAO_CUSTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ITEM_COMP_CUSTO_GR_COR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_COMUNICADO_PROD", foreignKey=@ForeignKey(name="FK_ITEM_COMP_CUSTO_IT_PROD"))
    public ItemComunicadoProducao getItemComProducao() {
        return this.itemComProducao;
    }

    public void setItemComProducao(ItemComunicadoProducao itemComProducao) {
        this.itemComProducao = itemComProducao;
    }

    @Column(name="VALOR_INICIAL")
    public Double getValorInicial() {
        return this.valorInicial;
    }

    public void setValorInicial(Double valorInicial) {
        this.valorInicial = valorInicial;
    }

    @Column(name="VALOR_REAL")
    public Double getValorReal() {
        return this.valorReal;
    }

    public void setValorReal(Double valorReal) {
        this.valorReal = valorReal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FASE_PRODUTIVA", foreignKey=@ForeignKey(name="FK_ITEM_COMP_CUSTO_FASE_PR"))
    public FaseProdutiva getFaseProdutiva() {
        return this.faseProdutiva;
    }

    public void setFaseProdutiva(FaseProdutiva faseProdutiva) {
        this.faseProdutiva = faseProdutiva;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_ITEM_COMPOSICAO_CUSTO_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_REFERENCIA")
    public Date getDataReferencia() {
        return this.dataReferencia;
    }

    public void setDataReferencia(Date dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Column(nullable=false, name="QUANTIDADE_REF")
    public Double getQuantidadeRef() {
        return this.quantidadeRef;
    }

    public void setQuantidadeRef(Double quantidadeRef) {
        this.quantidadeRef = quantidadeRef;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_COMPOSICAO_CUS_CEN_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Column(name="PRECO_MEDIO")
    public Double getPrecoMedio() {
        return this.precoMedio;
    }

    public void setPrecoMedio(Double precoMedio) {
        this.precoMedio = precoMedio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_OUTROS_CUSTOS", foreignKey=@ForeignKey(name="FK_ITEM_COMPOSICAO_CUS_IT_OU_CU"))
    public ItemComProdOutrosCustos getItemOutrosCustos() {
        return this.itemOutrosCustos;
    }

    public void setItemOutrosCustos(ItemComProdOutrosCustos itemOutrosCustos) {
        this.itemOutrosCustos = itemOutrosCustos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA")
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO")
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="FLAG_PROCESSAMENTO")
    public Short getFlagProcessamentoCusto() {
        return this.flagProcessamentoCusto;
    }

    public void setFlagProcessamentoCusto(Short flagProcessamentoCusto) {
        this.flagProcessamentoCusto = flagProcessamentoCusto;
    }
}

