/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemConsumoPagtoTranspAgregado;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_CONSUMO_ATIVO")
public class ItemConsumoAtivo
implements InterfaceVO {
    private Long identificador;
    private Short movInterno = 0;
    private Double valorUnitario = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotal = 0.0;
    private Double quantidadeTotal = 0.0;
    private CentroCusto centroCusto;
    private CentroEstoque centroEstoque;
    private Produto produto;
    private NaturezaRequisicao naturezaRequisicao;
    private List<GradeItemConsumoAtivo> gradeItemConsumoAtivo = new ArrayList<GradeItemConsumoAtivo>();
    private ConsumoAtivo consumoAtivo;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private ItemConsumoPagtoTranspAgregado itemConsumoTranspAgregado;
    private LancamentoCtbGerencial lancamentoCtbGerencial;
    private Short gerarPagamentoAgregado = 1;

    @Id
    @Column(nullable=false, name="ID_ITEM_CONSUMO_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_CONSUMO_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_CENT_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Column(name="MOV_INTERNO")
    public Short getMovInterno() {
        return this.movInterno;
    }

    public void setMovInterno(Short movInterno) {
        this.movInterno = movInterno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_NAT_REQ"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=6)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=6)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @OneToMany(mappedBy="itemConsumoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GradeItemConsumoAtivo> getGradeItemConsumoAtivo() {
        return this.gradeItemConsumoAtivo;
    }

    public void setGradeItemConsumoAtivo(List<GradeItemConsumoAtivo> gradeItemConsumoAtivo) {
        this.gradeItemConsumoAtivo = gradeItemConsumoAtivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONSUMO_ATIVO", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_CONS_ATIV"))
    public ConsumoAtivo getConsumoAtivo() {
        return this.consumoAtivo;
    }

    public void setConsumoAtivo(ConsumoAtivo consumoAtivo) {
        this.consumoAtivo = consumoAtivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_FORNECEDOR", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_UN_FAT_FO"))
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @OneToOne(mappedBy="itemConsumoAtivo", fetch=FetchType.LAZY)
    public ItemConsumoPagtoTranspAgregado getItemConsumoTranspAgregado() {
        return this.itemConsumoTranspAgregado;
    }

    public void setItemConsumoTranspAgregado(ItemConsumoPagtoTranspAgregado itemConsumoTranspAgregado) {
        this.itemConsumoTranspAgregado = itemConsumoTranspAgregado;
    }

    @OneToOne(targetEntity=LancamentoCtbGerencial.class, optional=true, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_LANCAMENTO_CTB_GERENCIAL", foreignKey=@ForeignKey(name="FK_ITEM_CONSUMO_ATIVO_LANC_GER"))
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getConsumoAtivo(), this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="GERAR_PAGAMENTO_AGREGADO")
    public Short getGerarPagamentoAgregado() {
        return this.gerarPagamentoAgregado;
    }

    public void setGerarPagamentoAgregado(Short gerarPagamentoAgregado) {
        this.gerarPagamentoAgregado = gerarPagamentoAgregado;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }
}

