/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_COTACAO_COMPRA")
public class ItemCotacaoCompra
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Double fatorConversao = 1.0;
    private Double quantidade = 0.0;
    private GradeCor gradeCor;
    private GradeCor gradeCorOriginal;
    private UnidadeMedida unidadeMedida;
    private CotacaoCompra cotacaoCompra;
    private NaturezaOperacao naturezaOperacao;
    private List<NecessidadeCompra> necessidadesCompra = new ArrayList<NecessidadeCompra>();
    private List<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra = new ArrayList<FornecedorItemCotacaoCompra>();
    private NaturezaRequisicao naturezaRequisicao;
    private CentroCusto centroCustoReq;
    private Short gerarReqLancarNota = 0;
    private Moeda moeda;
    private CotacaoMoeda cotacaoMoeda;
    private Equipamento ativo;
    private String observacao;
    private String justificativa;
    private Short naoGerarOC = 0;
    private Date dataMaxEntrega;

    @Id
    @Column(name="ID_ITEM_COTACAO_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_COTACAO_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="FATOR_CONVERSAO", precision=18, scale=6)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=18, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR_ORIGINAL", foreignKey=@ForeignKey(name="FK_ITEM_COT_COMPRA_GC_ORIG"))
    public GradeCor getGradeCorOriginal() {
        return this.gradeCorOriginal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_UM"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_COMPRA", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_COT"))
    public CotacaoCompra getCotacaoCompra() {
        return this.cotacaoCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_NATOP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @OneToMany(mappedBy="itemCotacaoCompraGerada", fetch=FetchType.LAZY, targetEntity=NecessidadeCompra.class)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NecessidadeCompra> getNecessidadesCompra() {
        return this.necessidadesCompra;
    }

    @OneToMany(mappedBy="itemCotacaoCompra", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public List<FornecedorItemCotacaoCompra> getFornecedoresItemCotacaoCompra() {
        return this.fornecedoresItemCotacaoCompra;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setGradeCorOriginal(GradeCor gradeCorOriginal) {
        this.gradeCorOriginal = gradeCorOriginal;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    public void setCotacaoCompra(CotacaoCompra cotacaoCompra) {
        this.cotacaoCompra = cotacaoCompra;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setNecessidadesCompra(List<NecessidadeCompra> necessidadesCompra) {
        this.necessidadesCompra = necessidadesCompra;
    }

    public void setFornecedoresItemCotacaoCompra(List<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra) {
        this.fornecedoresItemCotacaoCompra = fornecedoresItemCotacaoCompra;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getGradeCor() != null ? ToolBaseMethodsVO.toString((String)"Cotacao: {0} Produto: {1}", (Object[])new Object[]{this.getCotacaoCompra() != null ? this.getCotacaoCompra().getIdentificador() : "", this.getGradeCor().getProdutoGrade().getProduto().getNome()}) : ToolBaseMethodsVO.toString((String)"Cotacao: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_NAT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO_REQ", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_CC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCustoReq() {
        return this.centroCustoReq;
    }

    public void setCentroCustoReq(CentroCusto centroCustoReq) {
        this.centroCustoReq = centroCustoReq;
    }

    @Column(name="GERAR_LANC_REQ_NOTA")
    public Short getGerarReqLancarNota() {
        return this.gerarReqLancarNota;
    }

    public void setGerarReqLancarNota(Short gerarReqLancarNota) {
        this.gerarReqLancarNota = gerarReqLancarNota;
    }

    @Transient
    public Moeda getMoedaTransient() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @Transient
    public CotacaoMoeda getCotacaoMoedaTransient() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_COMPRA_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @Column(name="OBSERVACAO", length=2000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="JUSTIFICATIVA", length=500)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Column(name="NAO_GERAR_OC")
    public Short getNaoGerarOC() {
        return this.naoGerarOC;
    }

    public void setNaoGerarOC(Short naoGerarOC) {
        this.naoGerarOC = naoGerarOC;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MAXIMA_ENTREGA")
    public Date getDataMaxEntrega() {
        return this.dataMaxEntrega;
    }

    public void setDataMaxEntrega(Date dataMaxEntrega) {
        this.dataMaxEntrega = dataMaxEntrega;
    }
}

