/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.DuplicataTransporte;
import com.touchcomp.basementor.model.vo.ItemDupTransporteNotaPropria;
import com.touchcomp.basementor.model.vo.ItemDupTransporteNotaTerceiros;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaFrete;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TipoCTE;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_DUP_TRANSPORTE")
public class ItemDuplicataTransporte
implements InterfaceVO {
    private Long identificador;
    private List<ItemDupTransporteNotaPropria> itemDuplicataTransNF = new ArrayList<ItemDupTransporteNotaPropria>();
    private List<ItemDupTransporteNotaTerceiros> itemDuplicataTransNFTerc = new ArrayList<ItemDupTransporteNotaTerceiros>();
    private NotaFiscalTerceiros notaTercGerada;
    private UnidadeFederativa unidadeFederativa;
    private DuplicataTransporte duplicataTransporte;
    private CentroCusto centroCusto;
    private NaturezaOperacao naturezaOperacao;
    private Short tipoLancamento = 1;
    private String serie;
    private Long numeroNota;
    private Date dataEmissao;
    private Date dataEntradaSaida;
    private Date dataCompetencia;
    private Double valorInformadoCte = 0.0;
    private UnidadeFederativa ufPrestacao;
    private TipoCTE tipoCte;
    private ModeloDocFiscal modeloDocFiscal;
    private String chave;
    private Produto produto;
    private ModeloFiscal modeloFiscal;
    private Double valorIcms = 0.0;
    private Double bcFreteST = 0.0;
    private Double valorFreteST = 0.0;
    private CondicoesPagamento condicoesPagamento;
    private SituacaoDocumento situacaoDocumento;
    private NaturezaFrete naturezaFrete;
    private Double valorEstFrete = 0.0;
    private Short gerarNFTerceirosCte = 1;
    private Cidade cidadeOrigem;
    private Cidade cidadeDestino;
    private Cidade cidadePrestacao;
    private Short permiteRelacionarOutrosDocumentos = EnumConstantsMentorSimNao.NAO.getEnumId();
    private String chaveCteSubstituido;

    @Id
    @Column(nullable=false, name="ID_ITEM_DUP_TRANSPORTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_DUP_TRANSPORTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_NOTA_TERC_GERADA", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_NF_TERC"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public NotaFiscalTerceiros getNotaTercGerada() {
        return this.notaTercGerada;
    }

    public void setNotaTercGerada(NotaFiscalTerceiros notaTercGerada) {
        this.notaTercGerada = notaTercGerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FEDERATIVA", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_UF"))
    public UnidadeFederativa getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    public void setUnidadeFederativa(UnidadeFederativa unidadeFederativa) {
        this.unidadeFederativa = unidadeFederativa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DUPLICATA_TRANSPORTE", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_DUP_TRAN"))
    public DuplicataTransporte getDuplicataTransporte() {
        return this.duplicataTransporte;
    }

    public void setDuplicataTransporte(DuplicataTransporte duplicataTransporte) {
        this.duplicataTransporte = duplicataTransporte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_NAT_OP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemDuplicataTransporte")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemDupTransporteNotaPropria> getItemDuplicataTransNF() {
        return this.itemDuplicataTransNF;
    }

    public void setItemDuplicataTransNF(List<ItemDupTransporteNotaPropria> itemDuplicataTransNF) {
        this.itemDuplicataTransNF = itemDuplicataTransNF;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemDuplicataTransporte")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemDupTransporteNotaTerceiros> getItemDuplicataTransNFTerc() {
        return this.itemDuplicataTransNFTerc;
    }

    public void setItemDuplicataTransNFTerc(List<ItemDupTransporteNotaTerceiros> itemDuplicataTransNFTerc) {
        this.itemDuplicataTransNFTerc = itemDuplicataTransNFTerc;
    }

    @Column(name="TIPO_LANCAMENTO")
    public Short getTipoLancamento() {
        return this.tipoLancamento;
    }

    public void setTipoLancamento(Short tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Ignore
    @Column(nullable=false, name="NUMERO_NOTA")
    public Long getNumeroNota() {
        return this.numeroNota;
    }

    public void setNumeroNota(Long numeroNota) {
        this.numeroNota = numeroNota;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA_SAIDA")
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPETENCIA")
    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
    }

    @Column(nullable=false, name="VALOR_INFORMADO_CTE", precision=15, scale=2)
    public Double getValorInformadoCte() {
        return this.valorInformadoCte;
    }

    public void setValorInformadoCte(Double valorInformadoCte) {
        this.valorInformadoCte = valorInformadoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_PRESTACAO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_UF_PREST"))
    public UnidadeFederativa getUfPrestacao() {
        return this.ufPrestacao;
    }

    public void setUfPrestacao(UnidadeFederativa ufPrestacao) {
        this.ufPrestacao = ufPrestacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CTE", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_TIPO_CTE"))
    public TipoCTE getTipoCte() {
        return this.tipoCte;
    }

    public void setTipoCte(TipoCTE tipoCte) {
        this.tipoCte = tipoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_MOD_D_FI"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="CHAVE", length=44)
    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_MOD_FISC"))
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @Column(nullable=false, name="VALOR_ICMS", precision=15, scale=2)
    public Double getValorIcms() {
        return this.valorIcms;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
    }

    @Column(nullable=false, name="BC_FRETE_ST", precision=15, scale=2)
    public Double getBcFreteST() {
        return this.bcFreteST;
    }

    public void setBcFreteST(Double bcFreteST) {
        this.bcFreteST = bcFreteST;
    }

    @Column(nullable=false, name="VALOR_FRETE_ST", precision=15, scale=2)
    public Double getValorFreteST() {
        return this.valorFreteST;
    }

    public void setValorFreteST(Double valorFreteST) {
        this.valorFreteST = valorFreteST;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_SIT_DOC"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_FRETE", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSPORTE_NAT_FRET"))
    public NaturezaFrete getNaturezaFrete() {
        return this.naturezaFrete;
    }

    public void setNaturezaFrete(NaturezaFrete naturezaFrete) {
        this.naturezaFrete = naturezaFrete;
    }

    @Column(name="VALOR_EST_FRETE", precision=15, scale=2)
    public Double getValorEstFrete() {
        return this.valorEstFrete;
    }

    public void setValorEstFrete(Double valorEstFrete) {
        this.valorEstFrete = valorEstFrete;
    }

    @Column(name="GERAR_NF_TERCEIROS")
    public Short getGerarNFTerceirosCte() {
        return this.gerarNFTerceirosCte;
    }

    public void setGerarNFTerceirosCte(Short gerarNFTerceirosCte) {
        this.gerarNFTerceirosCte = gerarNFTerceirosCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_ORIGEM", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSP_CID_ORIGEM"))
    public Cidade getCidadeOrigem() {
        return this.cidadeOrigem;
    }

    public void setCidadeOrigem(Cidade cidadeOrigem) {
        this.cidadeOrigem = cidadeOrigem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_DESTINO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSP_CID_DESTINO"))
    public Cidade getCidadeDestino() {
        return this.cidadeDestino;
    }

    public void setCidadeDestino(Cidade cidadeDestino) {
        this.cidadeDestino = cidadeDestino;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_PRESTACAO", foreignKey=@ForeignKey(name="FK_ITEM_DUP_TRANSP_CIDADE_PREST"))
    public Cidade getCidadePrestacao() {
        return this.cidadePrestacao;
    }

    public void setCidadePrestacao(Cidade cidadePrestacao) {
        this.cidadePrestacao = cidadePrestacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Nmr. Nora: {0}", (Object[])new Object[]{this.getNumeroNota()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PERMITE_RELACIONAR_OUTROS_DOC")
    public Short getPermiteRelacionarOutrosDocumentos() {
        return this.permiteRelacionarOutrosDocumentos;
    }

    public void setPermiteRelacionarOutrosDocumentos(Short permiteRelacionarOutrosDocumentos) {
        this.permiteRelacionarOutrosDocumentos = permiteRelacionarOutrosDocumentos;
    }

    @Column(name="CHAVE_CTE_SUBSTITUIDO", length=44)
    public String getChaveCteSubstituido() {
        return this.chaveCteSubstituido;
    }

    public void setChaveCteSubstituido(String chaveCteSubstituido) {
        this.chaveCteSubstituido = chaveCteSubstituido;
    }
}

