/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.EmbalagemProduto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ITEM_EMBALAGEM_PRODUTO")
public class ItemEmbalagemProduto
implements InterfaceVO {
    private Long identificador;
    private Embalagem embalagem;
    private Double quantidade = 0.0;
    private EmbalagemProduto embalagemProduto;
    private Short indice;
    private Double percentualMajoracao;

    public ItemEmbalagemProduto() {
        this.indice = EnumConstantsMentorSimNao.SIM.value;
        this.percentualMajoracao = 0.0;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM", foreignKey=@ForeignKey(name="FK_ITEM_EMBALAGEM_PRODUTO_EMBAL"))
    public Embalagem getEmbalagem() {
        return this.embalagem;
    }

    public void setEmbalagem(Embalagem embalagem) {
        this.embalagem = embalagem;
    }

    @Column(name="QUANTIDADE", precision=15, scale=2)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @Column(name="INDICE")
    public Short getIndice() {
        return this.indice;
    }

    public void setIndice(Short indice) {
        this.indice = indice;
    }

    @Column(name="PERC_MAJORACAO", precision=15, scale=6)
    public Double getPercentualMajoracao() {
        return this.percentualMajoracao;
    }

    public void setPercentualMajoracao(Double percentualMajoracao) {
        this.percentualMajoracao = percentualMajoracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_EMBALAGEM_PRODUTO_EM_PR"))
    public EmbalagemProduto getEmbalagemProduto() {
        return this.embalagemProduto;
    }

    public void setEmbalagemProduto(EmbalagemProduto embalagemProduto) {
        this.embalagemProduto = embalagemProduto;
    }

    @Id
    @Column(nullable=false, name="ID_ITEM_EMBALAGEM_PRODUTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_EMBALAGEM_PRODUTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / Qtde: {1}", (Object[])new Object[]{this.getEmbalagem() != null ? this.getEmbalagem().getNome() : "", this.getQuantidade()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

