/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.FornecedorCotacao;
import com.touchcomp.basementor.model.vo.GradeItemFornecedorCotacao;
import com.touchcomp.basementor.model.vo.ItemFornCotacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.Marca;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_FORNECEDOR_COTACAO")
public class ItemFornecedorCotacao
implements InterfaceVO {
    private Long identificador;
    private Short aquisicaoPreferencial = 0;
    private Short HabilitarPercDesconto = 0;
    private Short HabilitarPercFrete = 0;
    private Short HabilitarPercSeguro = 0;
    private Short HabilitarPercDespAcessorias = 0;
    private String justficativaPreferencial;
    private Double fatorConversao = 0.0;
    private Double valorUnitario = 0.0;
    private Double perConcentracao = 0.0;
    private Double percDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double percFrete = 0.0;
    private Double valorFrete = 0.0;
    private Double percSeguro = 0.0;
    private Double valorSeguro = 0.0;
    private Double percDespAcessoria = 0.0;
    private Double valorDespAcessoria = 0.0;
    private Double valorProduto = 0.0;
    private Double valorServico = 0.0;
    private Double valorCusto = 0.0;
    private Marca marca;
    private Produto produto;
    private PlanoConta planoConta;
    private ModeloFiscal modeloFiscal;
    private UnidadeMedida unidadeMedida;
    private NaturezaOperacao naturezaOperacao;
    private FornecedorCotacao fornecedorCotacao;
    private PlanoContaGerencial planoContaGerencial;
    private ItemFornCotacaoLivroFiscal itemFornCotLF;
    private List<GradeItemFornecedorCotacao> gradeItemCotacao = new ArrayList<GradeItemFornecedorCotacao>();

    @Id
    @Column(name="ID_ITEM_FORNECEDOR_COTACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FORNECEDOR_ITEM_COTACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemFornecedorCotacao")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.PERSIST})
    public List<GradeItemFornecedorCotacao> getGradeItemCotacao() {
        return this.gradeItemCotacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_NAT_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @JoinColumn(name="ID_MARCA", foreignKey=@ForeignKey(name="FK_ITEM_FORN_MARCA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Marca getMarca() {
        return this.marca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_MOD_FISCAL"))
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_UND_MEDIDA"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @Column(name="FATOR_CONVERSAO", precision=12, scale=2)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=12, scale=2)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @Column(name="PERC_CONCENTRACAO", precision=12, scale=2)
    public Double getPerConcentracao() {
        return this.perConcentracao;
    }

    @Column(name="AQUISICAO_PREFERENCIAL")
    public Short getAquisicaoPreferencial() {
        return this.aquisicaoPreferencial;
    }

    @Column(nullable=false, name="JUSTIFICATIVA_PREFERENCIAL", length=100)
    public String getJustficativaPreferencial() {
        return this.justficativaPreferencial;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=12, scale=2)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=12, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(nullable=false, name="PERC_FRETE", precision=12, scale=2)
    public Double getPercFrete() {
        return this.percFrete;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=12, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(nullable=false, name="PERC_SEGURO", precision=12, scale=2)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    @Column(nullable=false, name="VALOR_SEGURO", precision=12, scale=2)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Column(nullable=false, name="PERC_DESP_ACESSORIA", precision=12, scale=2)
    public Double getPercDespAcessoria() {
        return this.percDespAcessoria;
    }

    @Column(nullable=false, name="VALOR_DESP_ACESSORIA", precision=12, scale=2)
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    @Column(nullable=false, name="VALOR_PRODUTO", precision=12, scale=2)
    public Double getValorProduto() {
        return this.valorProduto;
    }

    @Column(nullable=false, name="VALOR_SERVICO", precision=12, scale=2)
    public Double getValorServico() {
        return this.valorServico;
    }

    @Column(name="VALOR_CUSTO", precision=18, scale=2)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @JoinColumn(nullable=false, name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_PRODUTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Produto getProduto() {
        return this.produto;
    }

    @JoinColumn(name="ID_FORNECEDOR_COTACAO", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_FORN_COTACAO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public FornecedorCotacao getFornecedorCotacao() {
        return this.fornecedorCotacao;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_ITEM_FORN_COT_LF", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_ITEM_COT"))
    public ItemFornCotacaoLivroFiscal getItemFornCotLF() {
        return this.itemFornCotLF;
    }

    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_PLANO_CONTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_ITEM_FORN_COT_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    @Column(name="HABILITAR_PERC_DESCONTO")
    public Short getHabilitarPercDesconto() {
        return this.HabilitarPercDesconto;
    }

    @Column(name="HABILITAR_PERC_FRETE")
    public Short getHabilitarPercFrete() {
        return this.HabilitarPercFrete;
    }

    @Column(name="HABILITAR_PERC_SEGURO")
    public Short getHabilitarPercSeguro() {
        return this.HabilitarPercSeguro;
    }

    @Column(name="HABILITAR_PERC_DESP_ACESSORIAS")
    public Short getHabilitarPercDespAcessorias() {
        return this.HabilitarPercDespAcessorias;
    }

    @Transient
    public double getQuantidadeTotal() {
        double qtd = 0.0;
        if (this.getGradeItemCotacao() != null) {
            Iterator<GradeItemFornecedorCotacao> iterator = this.getGradeItemCotacao().iterator();
            while (iterator.hasNext()) {
                GradeItemFornecedorCotacao o;
                GradeItemFornecedorCotacao g = o = iterator.next();
                qtd += g.getQuantidade().doubleValue();
            }
        }
        return qtd;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setAquisicaoPreferencial(Short aquisicaoPreferencial) {
        this.aquisicaoPreferencial = aquisicaoPreferencial;
    }

    public void setHabilitarPercDesconto(Short HabilitarPercDesconto) {
        this.HabilitarPercDesconto = HabilitarPercDesconto;
    }

    public void setHabilitarPercFrete(Short HabilitarPercFrete) {
        this.HabilitarPercFrete = HabilitarPercFrete;
    }

    public void setHabilitarPercSeguro(Short HabilitarPercSeguro) {
        this.HabilitarPercSeguro = HabilitarPercSeguro;
    }

    public void setHabilitarPercDespAcessorias(Short HabilitarPercDespAcessorias) {
        this.HabilitarPercDespAcessorias = HabilitarPercDespAcessorias;
    }

    public void setJustficativaPreferencial(String justficativaPreferencial) {
        this.justficativaPreferencial = justficativaPreferencial;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setPerConcentracao(Double perConcentracao) {
        this.perConcentracao = perConcentracao;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    public void setPercDespAcessoria(Double percDespAcessoria) {
        this.percDespAcessoria = percDespAcessoria;
    }

    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    public void setValorProduto(Double valorProduto) {
        this.valorProduto = valorProduto;
    }

    public void setValorServico(Double valorServico) {
        this.valorServico = valorServico;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    public void setMarca(Marca marca) {
        this.marca = marca;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setFornecedorCotacao(FornecedorCotacao fornecedorCotacao) {
        this.fornecedorCotacao = fornecedorCotacao;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    public void setItemFornCotLF(ItemFornCotacaoLivroFiscal itemFornCotLF) {
        this.itemFornCotLF = itemFornCotLF;
    }

    public void setGradeItemCotacao(List<GradeItemFornecedorCotacao> gradeItemCotacao) {
        this.gradeItemCotacao = gradeItemCotacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

