/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CustoMensal;
import com.touchcomp.basementor.model.vo.GrApuracaoCredDebValorTouch;
import com.touchcomp.basementor.model.vo.GrApuracaoItemVendaTouch;
import com.touchcomp.basementor.model.vo.GrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.ItemOutrosServicosApuracao;
import com.touchcomp.basementor.model.vo.ItemReembolsoApuracao;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_GRUPO_APURACAO_CONTATO")
public class ItemGrupoApuracaoVlrContSistemas
implements InterfaceVO {
    private Long identificador;
    private GrupoApuracaoVlrContSistemas grupoApuracaoVlrContSistemas;
    private ClienteFinancContSistemas clienteFinancContSistemas;
    private Double valorTotal = 0.0;
    private Double valorMensal = 0.0;
    private Double valorReembolso = 0.0;
    private Double valorOutrosServicos = 0.0;
    private Double valorCredito = 0.0;
    private Double valorDebito = 0.0;
    private Double valorVenda = 0.0;
    private Double valorRenegociacao = 0.0;
    private Short infValorFatMensal = 0;
    private Double valorFatMensInf = 0.0;
    private List<ItemReembolsoApuracao> itensReembolsoApuracao = new ArrayList<ItemReembolsoApuracao>();
    private List<ItemOutrosServicosApuracao> itensOutrosServicosApuracao = new ArrayList<ItemOutrosServicosApuracao>();
    private List<GrApuracaoCredDebValorTouch> creditoValorTouch = new ArrayList<GrApuracaoCredDebValorTouch>();
    private List<GrApuracaoItemVendaTouch> itemVendaServicosTouch;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Rps rpsMensal;
    private Rps rpsVenda;
    private CustoMensal custoMensal;
    private String observacao;

    public ItemGrupoApuracaoVlrContSistemas() {
        this.itemVendaServicosTouch = new ArrayList<GrApuracaoItemVendaTouch>();
    }

    @Id
    @Column(nullable=false, name="ID_ITEM_GRUPO_APURACAO_CONTATO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_GRUPO_APURACAO_CONTATO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_APURACAO_CONTATO", foreignKey=@ForeignKey(name="FK_ITEM_GRUPO_APUR_CONTATO_GRUP"))
    public GrupoApuracaoVlrContSistemas getGrupoApuracaoVlrContSistemas() {
        return this.grupoApuracaoVlrContSistemas;
    }

    public void setGrupoApuracaoVlrContSistemas(GrupoApuracaoVlrContSistemas grupoApuracaoVlrContSistemas) {
        this.grupoApuracaoVlrContSistemas = grupoApuracaoVlrContSistemas;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CLIENTE_FINANC_CONT_SISTEMAS", foreignKey=@ForeignKey(name="FK_ITEM_GRUPO_APUR_CONTATO_CLIE"))
    public ClienteFinancContSistemas getClienteFinancContSistemas() {
        return this.clienteFinancContSistemas;
    }

    public void setClienteFinancContSistemas(ClienteFinancContSistemas clienteFinancContSistemas) {
        this.clienteFinancContSistemas = clienteFinancContSistemas;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="VALOR_MENSAL", precision=15, scale=2)
    public Double getValorMensal() {
        return this.valorMensal;
    }

    public void setValorMensal(Double valorMensal) {
        this.valorMensal = valorMensal;
    }

    @Column(name="VALOR_REEMBOLSO", precision=15, scale=2)
    public Double getValorReembolso() {
        return this.valorReembolso;
    }

    public void setValorReembolso(Double valorReembolso) {
        this.valorReembolso = valorReembolso;
    }

    @Column(name="VALOR_OUTROS_SERVICOS", precision=15, scale=2)
    public Double getValorOutrosServicos() {
        return this.valorOutrosServicos;
    }

    public void setValorOutrosServicos(Double valorOutrosServicos) {
        this.valorOutrosServicos = valorOutrosServicos;
    }

    @OneToMany(mappedBy="itemGrupoApuracaoVlrContSistemas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemReembolsoApuracao> getItensReembolsoApuracao() {
        return this.itensReembolsoApuracao;
    }

    public void setItensReembolsoApuracao(List<ItemReembolsoApuracao> itensReembolsoApuracao) {
        this.itensReembolsoApuracao = itensReembolsoApuracao;
    }

    @OneToMany(mappedBy="itemGrupoApuracaoVlrContSistemas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemOutrosServicosApuracao> getItensOutrosServicosApuracao() {
        return this.itensOutrosServicosApuracao;
    }

    public void setItensOutrosServicosApuracao(List<ItemOutrosServicosApuracao> itensOutrosServicosApuracao) {
        this.itensOutrosServicosApuracao = itensOutrosServicosApuracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_CREDITO", precision=15, scale=2)
    public Double getValorCredito() {
        return this.valorCredito;
    }

    public void setValorCredito(Double valorCredito) {
        this.valorCredito = valorCredito;
    }

    @Column(name="VALOR_VENDA", precision=15, scale=2)
    public Double getValorVenda() {
        return this.valorVenda;
    }

    public void setValorVenda(Double valorVenda) {
        this.valorVenda = valorVenda;
    }

    @OneToMany(mappedBy="itemGrupoApuracao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GrApuracaoCredDebValorTouch> getCreditoValorTouch() {
        return this.creditoValorTouch;
    }

    public void setCreditoValorTouch(List<GrApuracaoCredDebValorTouch> creditoValorTouch) {
        this.creditoValorTouch = creditoValorTouch;
    }

    @Column(name="VALOR_RENEGOCIACAO", precision=15, scale=2)
    public Double getValorRenegociacao() {
        return this.valorRenegociacao;
    }

    public void setValorRenegociacao(Double valorRenegociacao) {
        this.valorRenegociacao = valorRenegociacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RPS_MENSAL", foreignKey=@ForeignKey(name="FK_ITEM_GRUPO_APUR_CONTATO_MENS"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Rps getRpsMensal() {
        return this.rpsMensal;
    }

    public void setRpsMensal(Rps rpsMensal) {
        this.rpsMensal = rpsMensal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RPS_VENDA", foreignKey=@ForeignKey(name="FK_ITEM_GRUPO_APUR_CONTATO_VEND"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Rps getRpsVenda() {
        return this.rpsVenda;
    }

    public void setRpsVenda(Rps rpsVenda) {
        this.rpsVenda = rpsVenda;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="it_apur_vlr_titulos", inverseJoinColumns={@JoinColumn(name="id_titulo")}, joinColumns={@JoinColumn(name="id_item_apur_valores")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CUSTO_MENSAL", foreignKey=@ForeignKey(name="FK_ITEM_GRUPO_APUR_CUSTO_MENSAL"))
    public CustoMensal getCustoMensal() {
        return this.custoMensal;
    }

    public void setCustoMensal(CustoMensal custoMensal) {
        this.custoMensal = custoMensal;
    }

    @Column(nullable=false, name="VALOR_DEBITO", precision=15, scale=2)
    public Double getValorDebito() {
        return this.valorDebito;
    }

    public void setValorDebito(Double valorDebito) {
        this.valorDebito = valorDebito;
    }

    @Column(name="INF_VALOR_FAT_MENSAL")
    public Short getInfValorFatMensal() {
        return this.infValorFatMensal;
    }

    public void setInfValorFatMensal(Short infValorFatMensal) {
        this.infValorFatMensal = infValorFatMensal;
    }

    @Column(nullable=false, name="VALOR_FAT_MENS_INF", precision=15, scale=2)
    public Double getValorFatMensInf() {
        return this.valorFatMensInf;
    }

    public void setValorFatMensInf(Double valorFatMensInf) {
        this.valorFatMensInf = valorFatMensInf;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="itemGrupoApuracao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GrApuracaoItemVendaTouch> getItemVendaServicosTouch() {
        return this.itemVendaServicosTouch;
    }

    public void setItemVendaServicosTouch(List<GrApuracaoItemVendaTouch> itemVendaServicosTouch) {
        this.itemVendaServicosTouch = itemVendaServicosTouch;
    }
}

