/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.InfoAdicionalRotinaPeriodica;
import com.touchcomp.basementor.model.vo.ManutencaoRotinasPeriodicasPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_MANUTENCAO_ROTINAS")
public class ItemManutencaoRotinasPessoas
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Veiculo veiculo;
    private ExamePeriodo rotina;
    private Date dataVencimento;
    private Date dataRelizacao;
    private String observacao = "";
    private ManutencaoRotinasPeriodicasPessoas manutencao;
    private ItemManutencaoRotinasPessoas itemAnterior;
    private Short possuiInformacaoAdicional = 0;
    private InfoAdicionalRotinaPeriodica infoAdicionalRotina;
    private Long qtdOcorrenciaRealizada = 0L;
    private Funcao funcao;

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_MANUTENCAO_ROTINA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_MANUTENCAO_ROTINAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROT_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(targetEntity=Veiculo.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VEICULO", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROTINAS_VEIC"))
    public Veiculo getVeiculo() {
        return this.veiculo;
    }

    public void setVeiculo(Veiculo veiculo) {
        this.veiculo = veiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTINA", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROT_ROTINA"))
    public ExamePeriodo getRotina() {
        return this.rotina;
    }

    public void setRotina(ExamePeriodo rotina) {
        this.rotina = rotina;
    }

    @Column(name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(name="OBSERVACAO", length=50)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MANUTENCAO_ROTINA", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROT_MAN_ROT"))
    public ManutencaoRotinasPeriodicasPessoas getManutencao() {
        return this.manutencao;
    }

    public void setManutencao(ManutencaoRotinasPeriodicasPessoas manutencao) {
        this.manutencao = manutencao;
    }

    @Column(name="DATA_REALIZACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataRelizacao() {
        return this.dataRelizacao;
    }

    public void setDataRelizacao(Date dataRelizacao) {
        this.dataRelizacao = dataRelizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_MANUTENCAO_ANTERIOR", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROT_IT_MAN_A"))
    public ItemManutencaoRotinasPessoas getItemAnterior() {
        return this.itemAnterior;
    }

    public void setItemAnterior(ItemManutencaoRotinasPessoas itemAnterior) {
        this.itemAnterior = itemAnterior;
    }

    @Column(name="POSSUI_INFORMACAO_ADICIONAL")
    public Short getPossuiInformacaoAdicional() {
        return this.possuiInformacaoAdicional;
    }

    public void setPossuiInformacaoAdicional(Short possuiInformacaoAdicional) {
        this.possuiInformacaoAdicional = possuiInformacaoAdicional;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INFO_ADD_ROTINA_PERIODICA", foreignKey=@ForeignKey(name="FK_ITEM_MANUT_ROTINAS_INFO"))
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public InfoAdicionalRotinaPeriodica getInfoAdicionalRotina() {
        return this.infoAdicionalRotina;
    }

    public void setInfoAdicionalRotina(InfoAdicionalRotinaPeriodica infoAdicionalRotina) {
        this.infoAdicionalRotina = infoAdicionalRotina;
    }

    @Column(name="QTD_OCORRENCIA_REALIZADA")
    public Long getQtdOcorrenciaRealizada() {
        return this.qtdOcorrenciaRealizada;
    }

    public void setQtdOcorrenciaRealizada(Long qtdOcorrenciaRealizada) {
        this.qtdOcorrenciaRealizada = qtdOcorrenciaRealizada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_ITEM_MANUTENCAO_ROT_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }
}

