/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cest;
import com.touchcomp.basementor.model.vo.CodigoTributacaoDia;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaImportacao;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LancCtoItemNota;
import com.touchcomp.basementor.model.vo.LancCtoSaidaItemNota;
import com.touchcomp.basementor.model.vo.ModalidadeIcms;
import com.touchcomp.basementor.model.vo.ModalidadeIcmsSt;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ReinfNaturezaRendimento;
import com.touchcomp.basementor.model.vo.ReinfTipoServico;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.TicketEntradaItemNota;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="ITEM_NOTA_TERCEIROS")
public class ItemNotaTerceiros
implements InterfaceVO {
    private Long identificador;
    private Double valorUnitario = 0.0;
    private Double percDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double percFrete = 0.0;
    private Double valorFrete = 0.0;
    private Double percSeguro = 0.0;
    private Double vrSeguro = 0.0;
    private Double percDespAcessoria = 0.0;
    private Double valorDespAcessoria = 0.0;
    private Double vrFreteCtrc = 0.0;
    private Double vrProduto = 0.0;
    private Double abatimentoSuframa = 0.0;
    private Double vrServico = 0.0;
    private Integer numeroItem = 0;
    private Short indicadorTotal = 1;
    private Short modoArredondamento = 4;
    private Short naoCalcularIpi = 0;
    private Short naoCalcularIcms = 0;
    private NaturezaBCCredito naturezaBCCredito;
    private Double percValorAgregado = 0.0;
    private Double valorAgregado = 0.0;
    private Short desativarMovimento = 0;
    private ModeloFiscal modeloFiscal;
    private NaturezaOperacao naturezaOperacao;
    private IncidenciaIpi incidenciaIpi;
    private PlanoContaGerencial planoContaGerencial;
    private ModalidadeIcms modalidadeIcms;
    private ModalidadeIcmsSt modalidadeIcmsSt;
    private List<LancCtoItemNota> lancCtoEntrada = new ArrayList<LancCtoItemNota>();
    private List<LancCtoSaidaItemNota> lancCtoGerSaida = new ArrayList<LancCtoSaidaItemNota>();
    private IncidenciaPisCofins incidenciaPisCofins;
    private ItemNotaImportacao itemNotaImportacao;
    private IncidenciaIcms incidenciaIcms;
    private ItemNotaLivroFiscal itemNotaLivroFiscal;
    private ItemNotaFiscalPropria itemNotaTerceiro;
    private Produto produto;
    private UnidadeMedida unidadeMedida;
    private Double quantidadeTotal = 0.0;
    private NotaFiscalTerceiros notaFiscalTerceiros;
    private List<GradeItemNotaTerceiros> grade = new ArrayList<GradeItemNotaTerceiros>();
    private PlanoConta planoContaCred;
    private PlanoConta planoContaDeb;
    private Double fatorConversao = 1.0;
    private CentroEstoque centroEstoque;
    private Short naoCalcularPisCofins = 0;
    private RelacionamentoPessoa relacionamentoPessoa;
    private Short infVrCustoManual = 0;
    private Short gerarFinanceiro = 0;
    private Short informarValorAgregado = 0;
    private Short descontoItem = 0;
    private Short despAcessItem = 0;
    private Short seguroItem = 0;
    private Short freteItem = 0;
    private Short tipoDesconto = 1;
    private Short tipoFrete = 1;
    private Short naoRatearFreteCtrc = 0;
    private Short tipoSeguro = 1;
    private Short tipoDespAcessoria = 1;
    private ReinfTipoServico tipoServico;
    private CentroCusto centroCusto;
    private Short issRetido = 0;
    private Ncm ncm;
    private Cest cest;
    private List<TicketEntradaItemNota> ticketEntradaItemNota = new ArrayList<TicketEntradaItemNota>();
    private String descricaoComplementar;
    private String unidadeMedidaXML;
    private ReinfNaturezaRendimento naturezaRendimento;
    private CodigoTributacaoDia codigoTributacaoDia;

    @Id
    @Column(name="ID_ITEM_NOTA_TERCEIROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_NOTA_TERCEIROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=12, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=12, scale=2)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=12, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(name="PERC_FRETE", precision=15, scale=4)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(name="VALOR_FRETE", precision=12, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(name="PERC_SEGURO", precision=15, scale=4)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Column(name="VR_SEGURO", precision=12, scale=2)
    public Double getVrSeguro() {
        return this.vrSeguro;
    }

    public void setVrSeguro(Double vrSeguro) {
        this.vrSeguro = vrSeguro;
    }

    @Column(name="PERC_DESP_ACESSORIA", precision=15, scale=4)
    public Double getPercDespAcessoria() {
        return this.percDespAcessoria;
    }

    public void setPercDespAcessoria(Double percDespAcessoria) {
        this.percDespAcessoria = percDespAcessoria;
    }

    @Column(name="VALOR_DESP_ACESSORIA", precision=12, scale=2)
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    @Column(name="VALOR_FRETE_CTRC", precision=12, scale=2)
    public Double getVrFreteCtrc() {
        return this.vrFreteCtrc;
    }

    public void setVrFreteCtrc(Double vrFreteCtrc) {
        this.vrFreteCtrc = vrFreteCtrc;
    }

    @Column(name="VR_PRODUTO", precision=12, scale=2)
    public Double getVrProduto() {
        return this.vrProduto;
    }

    public void setVrProduto(Double vrProduto) {
        this.vrProduto = vrProduto;
    }

    @Column(name="ABATIMENTO_SUFRAMA", precision=12, scale=2)
    public Double getAbatimentoSuframa() {
        return this.abatimentoSuframa;
    }

    public void setAbatimentoSuframa(Double abatimentoSuframa) {
        this.abatimentoSuframa = abatimentoSuframa;
    }

    @Column(nullable=false, name="VR_SERVICO", precision=12, scale=2)
    public Double getVrServico() {
        return this.vrServico;
    }

    public void setVrServico(Double vrServico) {
        this.vrServico = vrServico;
    }

    @Column(nullable=false, name="NUMERO_ITEM")
    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    public void setNumeroItem(Integer numeroItem) {
        this.numeroItem = numeroItem;
    }

    @Column(name="INDICADOR_TOTAL")
    public Short getIndicadorTotal() {
        return this.indicadorTotal;
    }

    public void setIndicadorTotal(Short indicadorTotal) {
        this.indicadorTotal = indicadorTotal;
    }

    @Column(name="MODO_ARREDONDAMENTO")
    public Short getModoArredondamento() {
        return this.modoArredondamento;
    }

    public void setModoArredondamento(Short modoArredondamento) {
        this.modoArredondamento = modoArredondamento;
    }

    @Column(name="NAO_CALCULAR_IPI")
    public Short getNaoCalcularIpi() {
        return this.naoCalcularIpi;
    }

    public void setNaoCalcularIpi(Short naoCalcularIpi) {
        this.naoCalcularIpi = naoCalcularIpi;
    }

    @Column(name="NAO_CALCULAR_ICMS")
    public Short getNaoCalcularIcms() {
        return this.naoCalcularIcms;
    }

    public void setNaoCalcularIcms(Short naoCalcularIcms) {
        this.naoCalcularIcms = naoCalcularIcms;
    }

    @JoinColumn(name="ID_NAT_BC_CREDITO", foreignKey=@ForeignKey(name="FK_ITEM_NT_NATUREZA_BC_CREDITO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NaturezaBCCredito getNaturezaBCCredito() {
        return this.naturezaBCCredito;
    }

    public void setNaturezaBCCredito(NaturezaBCCredito naturezaBCCredito) {
        this.naturezaBCCredito = naturezaBCCredito;
    }

    @Column(name="PERC_VALOR_AGREGADO", precision=15, scale=4)
    public Double getPercValorAgregado() {
        return this.percValorAgregado;
    }

    public void setPercValorAgregado(Double percValorAgregado) {
        this.percValorAgregado = percValorAgregado;
    }

    @Column(name="VALOR_AGREGADO", precision=15, scale=4)
    public Double getValorAgregado() {
        return this.valorAgregado;
    }

    public void setValorAgregado(Double valorAgregado) {
        this.valorAgregado = valorAgregado;
    }

    @Column(name="DESATIVA_MOV_TERCEIROS")
    public Short getDesativarMovimento() {
        return this.desativarMovimento;
    }

    public void setDesativarMovimento(Short desativarMovimento) {
        this.desativarMovimento = desativarMovimento;
    }

    @JoinColumn(nullable=false, name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_NT_MODELO_FISCAL"))
    @ManyToOne(fetch=FetchType.EAGER)
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ITEM_NT_NATUREZA_OPERACAO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @JoinColumn(name="ID_INCIDENCIA_IPI", foreignKey=@ForeignKey(name="FK_ITEM_NT_INCIDENCIA_IPI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaIpi getIncidenciaIpi() {
        return this.incidenciaIpi;
    }

    public void setIncidenciaIpi(IncidenciaIpi incidenciaIpi) {
        this.incidenciaIpi = incidenciaIpi;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_ITEM_NT_PLANO_CONTA_GERENC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @JoinColumn(name="ID_MODALIDADE_ICMS", foreignKey=@ForeignKey(name="FK_ITEM_NT_MODALIDADE_ICMS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModalidadeIcms getModalidadeIcms() {
        return this.modalidadeIcms;
    }

    public void setModalidadeIcms(ModalidadeIcms modalidadeIcms) {
        this.modalidadeIcms = modalidadeIcms;
    }

    @JoinColumn(name="ID_MODALIDADE_ICMS_ST", foreignKey=@ForeignKey(name="FK_ITEM_NT_MODALIDADE_ICMS_ST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModalidadeIcmsSt getModalidadeIcmsSt() {
        return this.modalidadeIcmsSt;
    }

    public void setModalidadeIcmsSt(ModalidadeIcmsSt modalidadeIcmsSt) {
        this.modalidadeIcmsSt = modalidadeIcmsSt;
    }

    @OneToMany(mappedBy="itemNotaTerceiros", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<LancCtoItemNota> getLancCtoEntrada() {
        return this.lancCtoEntrada;
    }

    public void setLancCtoEntrada(List<LancCtoItemNota> lancCtoEntrada) {
        this.lancCtoEntrada = lancCtoEntrada;
    }

    @OneToMany(mappedBy="itemNotaTerceiros", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<LancCtoSaidaItemNota> getLancCtoGerSaida() {
        return this.lancCtoGerSaida;
    }

    public void setLancCtoGerSaida(List<LancCtoSaidaItemNota> lancCtoGerSaida) {
        this.lancCtoGerSaida = lancCtoGerSaida;
    }

    @JoinColumn(name="ID_INCIDENCIA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_ITEM_NT_INCID_PIS_COFINS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaPisCofins getIncidenciaPisCofins() {
        return this.incidenciaPisCofins;
    }

    public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
        this.incidenciaPisCofins = incidenciaPisCofins;
    }

    @JoinColumn(name="ID_ITEM_NOTA_IMPORTACAO", foreignKey=@ForeignKey(name="FK_ITEM_NT_NOTA_IMPORTACAO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemNotaImportacao getItemNotaImportacao() {
        return this.itemNotaImportacao;
    }

    public void setItemNotaImportacao(ItemNotaImportacao itemNotaImportacao) {
        this.itemNotaImportacao = itemNotaImportacao;
    }

    @JoinColumn(name="ID_INCIDENCIA_ICMS", foreignKey=@ForeignKey(name="FK_ITEM_NT_INCIDENCIA_ICMS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IncidenciaIcms getIncidenciaIcms() {
        return this.incidenciaIcms;
    }

    public void setIncidenciaIcms(IncidenciaIcms incidenciaIcms) {
        this.incidenciaIcms = incidenciaIcms;
    }

    @OneToOne(mappedBy="itemNotaTerceiros", cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.TRUE)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ItemNotaLivroFiscal getItemNotaLivroFiscal() {
        return this.itemNotaLivroFiscal;
    }

    public void setItemNotaLivroFiscal(ItemNotaLivroFiscal itemNotaLivroFiscal) {
        this.itemNotaLivroFiscal = itemNotaLivroFiscal;
    }

    @JoinColumn(name="ID_ITEM_NOTA_TERCEIRO", foreignKey=@ForeignKey(name="FK_ITEM_NT_ITEM_NP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemNotaFiscalPropria getItemNotaTerceiro() {
        return this.itemNotaTerceiro;
    }

    public void setItemNotaTerceiro(ItemNotaFiscalPropria itemNotaTerceiro) {
        this.itemNotaTerceiro = itemNotaTerceiro;
    }

    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_NT_PRODUTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_NT_UNIDADE_MEDIDA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=4)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @JoinColumn(nullable=false, name="ID_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_ITEM_NT_NOTA_TERCEIROS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NotaFiscalTerceiros getNotaFiscalTerceiros() {
        return this.notaFiscalTerceiros;
    }

    public void setNotaFiscalTerceiros(NotaFiscalTerceiros notaFiscalTerceiros) {
        this.notaFiscalTerceiros = notaFiscalTerceiros;
    }

    @OneToMany(mappedBy="itemNotaTerceiros", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GradeItemNotaTerceiros> getGrade() {
        return this.grade;
    }

    public void setGrade(List<GradeItemNotaTerceiros> grade) {
        this.grade = grade;
        if (grade != null) {
            Double qtdTotal = 0.0;
            if (Hibernate.isInitialized(grade)) {
                Iterator<GradeItemNotaTerceiros> iterator = grade.iterator();
                while (iterator.hasNext()) {
                    GradeItemNotaTerceiros o;
                    GradeItemNotaTerceiros g = o = iterator.next();
                    qtdTotal = qtdTotal + g.getQuantidade();
                }
            }
            this.setQuantidadeTotal(qtdTotal);
        } else {
            this.setQuantidadeTotal(0.0);
        }
    }

    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_ITEM_NT_PLANO_CONTA_CRED"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaCred() {
        return this.planoContaCred;
    }

    public void setPlanoContaCred(PlanoConta planoContaCred) {
        this.planoContaCred = planoContaCred;
    }

    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_ITEM_NT_PLANO_CONTA_DEB"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaDeb() {
        return this.planoContaDeb;
    }

    public void setPlanoContaDeb(PlanoConta planoContaDeb) {
        this.planoContaDeb = planoContaDeb;
    }

    @Column(nullable=false, name="FATOR_CONVERSAO", precision=15, scale=4)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Ignore
    @Transient
    public Short getMovimentacaoFisica() {
        if (this.getGrade() != null && !this.getGrade().isEmpty()) {
            return this.getGrade().get(0).getMovimentacaoFisica();
        }
        return null;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getProduto() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getProduto().getIdentificador(), this.getProduto().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_CENT_EST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroestoque) {
        this.centroEstoque = centroestoque;
    }

    @Column(name="NAO_CALCULAR_PIS_COFINS")
    public Short getNaoCalcularPisCofins() {
        return this.naoCalcularPisCofins;
    }

    public void setNaoCalcularPisCofins(Short naoCalcularPisCofins) {
        this.naoCalcularPisCofins = naoCalcularPisCofins;
    }

    @JoinColumn(name="ID_RELACIONAMENTO_PESSOA", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_REL_PESS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public RelacionamentoPessoa getRelacionamentoPessoa() {
        return this.relacionamentoPessoa;
    }

    public void setRelacionamentoPessoa(RelacionamentoPessoa relacionamentoPessoa) {
        this.relacionamentoPessoa = relacionamentoPessoa;
    }

    @Column(name="INF_VR_CUSTO_MANUAL")
    public Short getInfVrCustoManual() {
        return this.infVrCustoManual;
    }

    public void setInfVrCustoManual(Short infVrCustoManual) {
        this.infVrCustoManual = infVrCustoManual;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="INF_VALOR_AGREGADO")
    public Short getInformarValorAgregado() {
        return this.informarValorAgregado;
    }

    public void setInformarValorAgregado(Short informarValorAgregado) {
        this.informarValorAgregado = informarValorAgregado;
    }

    @Column(name="DESCONTO_ITEM")
    public Short getDescontoItem() {
        return this.descontoItem;
    }

    public void setDescontoItem(Short descontoItem) {
        this.descontoItem = descontoItem;
    }

    @Column(name="DESP_ACESS_ITEM")
    public Short getDespAcessItem() {
        return this.despAcessItem;
    }

    public void setDespAcessItem(Short despAcessItem) {
        this.despAcessItem = despAcessItem;
    }

    @Column(name="SEGURO_ITEM")
    public Short getSeguroItem() {
        return this.seguroItem;
    }

    public void setSeguroItem(Short seguroItem) {
        this.seguroItem = seguroItem;
    }

    @Column(name="FRETE_ITEM")
    public Short getFreteItem() {
        return this.freteItem;
    }

    public void setFreteItem(Short freteItem) {
        this.freteItem = freteItem;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="TIPO_FRETE")
    public Short getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(Short tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="TIPO_SEGURO")
    public Short getTipoSeguro() {
        return this.tipoSeguro;
    }

    public void setTipoSeguro(Short tipoSeguro) {
        this.tipoSeguro = tipoSeguro;
    }

    @Column(name="TIPO_DESP_ACESSORIA")
    public Short getTipoDespAcessoria() {
        return this.tipoDespAcessoria;
    }

    public void setTipoDespAcessoria(Short tipoDespAcessoria) {
        this.tipoDespAcessoria = tipoDespAcessoria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_TP_SERVICO", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TER_TP_SERVICO"))
    public ReinfTipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(ReinfTipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @Column(name="NAO_RATEAR_FRETE_CTRC")
    public Short getNaoRatearFreteCtrc() {
        return this.naoRatearFreteCtrc;
    }

    public void setNaoRatearFreteCtrc(Short naoRatearFreteCtrc) {
        this.naoRatearFreteCtrc = naoRatearFreteCtrc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="ISS_RETIDO")
    public Short getIssRetido() {
        return this.issRetido;
    }

    public void setIssRetido(Short issRetido) {
        this.issRetido = issRetido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NCM", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_NCM"))
    public Ncm getNcm() {
        return this.ncm;
    }

    public void setNcm(Ncm ncm) {
        this.ncm = ncm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CEST", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_CEST"))
    public Cest getCest() {
        return this.cest;
    }

    public void setCest(Cest cest) {
        this.cest = cest;
    }

    @OneToMany(mappedBy="itemNota", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TicketEntradaItemNota> getTicketEntradaItemNota() {
        return this.ticketEntradaItemNota;
    }

    public void setTicketEntradaItemNota(List<TicketEntradaItemNota> ticketEntradaItemNota) {
        this.ticketEntradaItemNota = ticketEntradaItemNota;
    }

    @Column(name="DESCRICAO_COMPLEMENTAR", length=120)
    public String getDescricaoComplementar() {
        return this.descricaoComplementar;
    }

    public void setDescricaoComplementar(String descricaoComplementar) {
        this.descricaoComplementar = descricaoComplementar;
    }

    @Column(name="UNIDADE_MEDIDA_XML", length=10)
    public String getUnidadeMedidaXML() {
        return this.unidadeMedidaXML;
    }

    public void setUnidadeMedidaXML(String unidadeMedidaXML) {
        this.unidadeMedidaXML = unidadeMedidaXML;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_RENDIMENTO_REINF")
    public ReinfNaturezaRendimento getNaturezaRendimento() {
        return this.naturezaRendimento;
    }

    public void setNaturezaRendimento(ReinfNaturezaRendimento naturezaRendimento) {
        this.naturezaRendimento = naturezaRendimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CODIGO_TRIBUTACAO_DIA", foreignKey=@ForeignKey(name="FK_ITEM_NOTA_TERCEIROS_COD_TRIB"))
    public CodigoTributacaoDia getCodigoTributacaoDia() {
        return this.codigoTributacaoDia;
    }

    public void setCodigoTributacaoDia(CodigoTributacaoDia codigoTributacaoDia) {
        this.codigoTributacaoDia = codigoTributacaoDia;
    }
}

