/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraNecCompra;
import com.touchcomp.basementor.model.vo.ItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.Marca;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProjetoPCP;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_ORDEM_COMPRA")
public class ItemOrdemCompra
implements InterfaceVO {
    private Long identificador;
    private String complemento;
    private String observacoes;
    private Short fechado = 0;
    private Short gerarReqLancarNota = 0;
    private Double valorUnitario = 0.0;
    private Double vrProduto = 0.0;
    private Double vrServico = 0.0;
    private Double valorAgregado = 0.0;
    private Double quantidadeTotal = 0.0;
    private Double fatorConversao = 1.0;
    private Marca marca;
    private Produto produto;
    private PlanoConta planoContaDeb;
    private Equipamento ativo;
    private CentroCusto centroCustoReq;
    private OrdemCompra ordemCompra;
    private ModeloFiscal modeloFiscal;
    private UnidadeMedida unidadeMedida;
    private NaturezaOperacao naturezaOperacao;
    private ItemUnidadeMedida itemUnidadeMedida;
    private NaturezaRequisicao naturezaRequisicao;
    private PlanoContaGerencial planoContaGerencial;
    private ItemOrdemCompraLivroFiscal itemOrdemCompraLF;
    private List<GradeItemOrdemCompra> gradeItemOrdemCompra = new ArrayList<GradeItemOrdemCompra>();
    private List<ItemRecepcaoMercadorias> itemRecepcaoMercadorias = new ArrayList<ItemRecepcaoMercadorias>();
    private Double valorCusto = 0.0;
    private Long prazoEntrega = 0L;
    private Double valorDesconto = 0.0;
    private Double valorFrete = 0.0;
    private Double vrSeguro = 0.0;
    private Double valorDespAcessoria = 0.0;
    private Double percDesconto = 0.0;
    private Double percFrete = 0.0;
    private Double percDespesaAcessoria = 0.0;
    private Double percSeguro = 0.0;
    private Short descontoItem = 0;
    private Short despAcessItem = 0;
    private Short seguroItem = 0;
    private Short freteItem = 0;
    private Short tipoDesconto = 1;
    private Short tipoFrete = 1;
    private Short tipoSeguro = 1;
    private Short tipoDespAcessoria = 1;
    private Integer nrSequencial = 0;
    private Timestamp dataAtualizacao;
    private List<ItemOrdemCompraNecCompra> itemOrdemCompraNecCompra = new ArrayList<ItemOrdemCompraNecCompra>();
    private Double valorUnitarioMoeda = 0.0;
    private Moeda moeda;
    private CotacaoMoeda cotacaoMoeda;
    private ProjetoPCP projetoPCP;
    private Double valorTotalConvertido = 0.0;
    private Short dolarNegociado = EnumConstantsMentorSimNao.SIM.getValue();
    private Date dataEntrega;

    @Id
    @Column(nullable=false, name="ID_ITEM_ORDEM_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_ORDEM_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="COMPLEMENTO", precision=18, scale=6)
    public String getComplemento() {
        return this.complemento;
    }

    @Column(name="OBSERVACOES", length=2000)
    public String getObservacoes() {
        return this.observacoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COM_NAT_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @Transient
    public ItemUnidadeMedida getItemUnidadeMedida() {
        return this.itemUnidadeMedida;
    }

    @Column(name="VALOR_DESCONTO", precision=18, scale=6)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(name="VALOR_DESP_ACESSORIA", precision=18, scale=6)
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    @Column(name="VALOR_FRETE", precision=18, scale=6)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(name="VALOR_UNITARIO", precision=18, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @Column(name="VR_PRODUTO", precision=18, scale=6)
    public Double getVrProduto() {
        return this.vrProduto;
    }

    @Column(name="VR_SEGURO", precision=18, scale=6)
    public Double getVrSeguro() {
        return this.vrSeguro;
    }

    @Column(name="VR_SERVICO", precision=18, scale=6)
    public Double getVrServico() {
        return this.vrServico;
    }

    @JoinColumn(name="ID_MARCA", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_MARCA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Marca getMarca() {
        return this.marca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_MOD_FISCAL"))
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(nullable=false, name="ID_ITEM_ORD_COMPRA_LF", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_ITEM_LF"))
    public ItemOrdemCompraLivroFiscal getItemOrdemCompraLF() {
        return this.itemOrdemCompraLF;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemOrdemCompra")
    public List<ItemRecepcaoMercadorias> getItemRecepcaoMercadorias() {
        return this.itemRecepcaoMercadorias;
    }

    @Column(name="FECHADO")
    public Short getFechado() {
        return this.fechado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_PC_GERENCI"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO_REQ", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_C_CUSTO"))
    public CentroCusto getCentroCustoReq() {
        return this.centroCustoReq;
    }

    @Column(name="GERAR_LANC_REQ_NOTA")
    public Short getGerarReqLancarNota() {
        return this.gerarReqLancarNota;
    }

    @Column(name="VALOR_AGREGADO", precision=15, scale=4)
    public Double getValorAgregado() {
        return this.valorAgregado;
    }

    @JoinColumn(nullable=false, name="ID_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_OC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public OrdemCompra getOrdemCompra() {
        return this.ordemCompra;
    }

    @JoinColumn(name="ID_PC_DEB", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_PC_DEB"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaDeb() {
        return this.planoContaDeb;
    }

    @JoinColumn(nullable=false, name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_PRODUTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Produto getProduto() {
        return this.produto;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=18, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @JoinColumn(nullable=false, name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_UN_MEDIDA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @OneToMany(mappedBy="itemOrdemCompra")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GradeItemOrdemCompra> getGradeItemOrdemCompra() {
        return this.gradeItemOrdemCompra;
    }

    @Column(name="FATOR_CONVERSAO", precision=15, scale=6)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_NAT_REQ"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public void setFechado(Short fechado) {
        this.fechado = fechado;
    }

    public void setGerarReqLancarNota(Short gerarReqLancarNota) {
        this.gerarReqLancarNota = gerarReqLancarNota;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setVrSeguro(Double vrSeguro) {
        this.vrSeguro = vrSeguro;
    }

    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    public void setVrProduto(Double vrProduto) {
        this.vrProduto = vrProduto;
    }

    public void setVrServico(Double vrServico) {
        this.vrServico = vrServico;
    }

    public void setValorAgregado(Double valorAgregado) {
        this.valorAgregado = valorAgregado;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    public void setMarca(Marca marca) {
        this.marca = marca;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public void setPlanoContaDeb(PlanoConta planoContaDeb) {
        this.planoContaDeb = planoContaDeb;
    }

    public void setCentroCustoReq(CentroCusto centroCustoReq) {
        this.centroCustoReq = centroCustoReq;
    }

    public void setOrdemCompra(OrdemCompra ordemCompra) {
        this.ordemCompra = ordemCompra;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setItemUnidadeMedida(ItemUnidadeMedida itemUnidadeMedida) {
        this.itemUnidadeMedida = itemUnidadeMedida;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    public void setItemOrdemCompraLF(ItemOrdemCompraLivroFiscal itemOrdemCompraLF) {
        this.itemOrdemCompraLF = itemOrdemCompraLF;
    }

    public void setItemRecepcaoMercadorias(List<ItemRecepcaoMercadorias> itemRecepcaoMercadorias) {
        this.itemRecepcaoMercadorias = itemRecepcaoMercadorias;
    }

    public void setGradeItemOrdemCompra(List<GradeItemOrdemCompra> gradeItemOrdemCompra) {
        this.gradeItemOrdemCompra = gradeItemOrdemCompra;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return super.toString();
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_CUSTO", precision=18, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    @Column(name="PRAZO_ENTREGA")
    public Long getPrazoEntrega() {
        return this.prazoEntrega;
    }

    public void setPrazoEntrega(Long prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    @Column(name="DESCONTO_ITEM")
    public Short getDescontoItem() {
        return this.descontoItem;
    }

    public void setDescontoItem(Short descontoItem) {
        this.descontoItem = descontoItem;
    }

    @Column(name="DESP_ACESS_ITEM")
    public Short getDespAcessItem() {
        return this.despAcessItem;
    }

    public void setDespAcessItem(Short despAcessItem) {
        this.despAcessItem = despAcessItem;
    }

    @Column(name="SEGURO_ITEM")
    public Short getSeguroItem() {
        return this.seguroItem;
    }

    public void setSeguroItem(Short seguroItem) {
        this.seguroItem = seguroItem;
    }

    @Column(name="FRETE_ITEM")
    public Short getFreteItem() {
        return this.freteItem;
    }

    public void setFreteItem(Short freteItem) {
        this.freteItem = freteItem;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="TIPO_FRETE")
    public Short getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(Short tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="TIPO_SEGURO")
    public Short getTipoSeguro() {
        return this.tipoSeguro;
    }

    public void setTipoSeguro(Short tipoSeguro) {
        this.tipoSeguro = tipoSeguro;
    }

    @Column(name="TIPO_DESP_ACESS")
    public Short getTipoDespAcessoria() {
        return this.tipoDespAcessoria;
    }

    public void setTipoDespAcessoria(Short tipoDespAcessoria) {
        this.tipoDespAcessoria = tipoDespAcessoria;
    }

    @Column(name="PERC_DESCONTO", precision=18, scale=6)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(name="PERC_FRETE", precision=18, scale=6)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(name="PERC_DESP_ACESSORIA", precision=18, scale=6)
    public Double getPercDespesaAcessoria() {
        return this.percDespesaAcessoria;
    }

    public void setPercDespesaAcessoria(Double percDespesaAcessoria) {
        this.percDespesaAcessoria = percDespesaAcessoria;
    }

    @Column(name="PERC_SEGURO", precision=18, scale=6)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Column(name="NR_SEQUENCIAL")
    public Integer getNrSequencial() {
        return this.nrSequencial;
    }

    public void setNrSequencial(Integer nrSequencial) {
        this.nrSequencial = nrSequencial;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="itemOrdemCompra", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemOrdemCompraNecCompra> getItemOrdemCompraNecCompra() {
        return this.itemOrdemCompraNecCompra;
    }

    public void setItemOrdemCompraNecCompra(List<ItemOrdemCompraNecCompra> itemOrdemCompraNecCompra) {
        this.itemOrdemCompraNecCompra = itemOrdemCompraNecCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @Column(name="VALOR_UNITARIO_MOEDA", precision=18, scale=6)
    public Double getValorUnitarioMoeda() {
        return this.valorUnitarioMoeda;
    }

    public void setValorUnitarioMoeda(Double valorUnitarioMoeda) {
        this.valorUnitarioMoeda = valorUnitarioMoeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA", foreignKey=@ForeignKey(name="FK_ITEM_OC_MOEDA"))
    public Moeda getMoeda() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_ITEM_OC_COT_MOED"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROJETO_PCP", foreignKey=@ForeignKey(name="FK_ITEM_ORDEM_COMPRA_PROJ_PCP"))
    public ProjetoPCP getProjetoPCP() {
        return this.projetoPCP;
    }

    public void setProjetoPCP(ProjetoPCP projetoPCP) {
        this.projetoPCP = projetoPCP;
    }

    @Column(name="VALOR_TOTAL_CONVERTIDO")
    public Double getValorTotalConvertido() {
        return this.valorTotalConvertido;
    }

    public void setValorTotalConvertido(Double valorTotalConvertido) {
        this.valorTotalConvertido = valorTotalConvertido;
    }

    @Column(name="DOLAR_CONFIRMADO")
    public Short getDolarNegociado() {
        return this.dolarNegociado;
    }

    public void setDolarNegociado(Short dolarNegociado) {
        this.dolarNegociado = dolarNegociado;
    }

    @Column(name="DATA_ENTREGA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntrega() {
        return this.dataEntrega;
    }

    public void setDataEntrega(Date dataEntrega) {
        this.dataEntrega = dataEntrega;
    }
}

