/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LogItemPedido;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoItemPedido;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_PEDIDO_COMERCIO")
public class ItemPedidoComercio
implements InterfaceVO {
    private Long identificador;
    private Double valorUnitario = 0.0;
    private Double valorTotal = 0.0;
    private Produto produto;
    private Double quantidadeTotal = 0.0;
    private Short nrItemPedido = 1;
    private SituacaoItemPedido situacaoItemPedido;
    private PedidoComercio pedidoComercio;
    private Double percentualDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotalBruto = 0.0;
    private Double valorAcrescimo = 0.0;
    private Double percAcrescimo = 0.0;
    private Short itemCancelado = 0;
    private String motivoCancelamento;
    private Usuario usuarioCancelamento;
    private List<LogItemPedido> logItemPedido = new ArrayList<LogItemPedido>();
    private Representante representante;
    private GradeCor gradeCor;
    private Usuario usuario;
    private Double percComissao = 0.0;
    private Double valorComissao = 0.0;
    private CentroEstoque centroEstoque;
    private LoteFabricacao loteFabricacao;
    private Short movimentarEstoque = 0;
    private Date dataMovimentacao;
    private Double vlrTabelaPreco = 0.0;
    private Short descontoItem = 0;
    private Short tipoDesconto = 1;
    private Short acrescimoItem = 0;
    private Short tipoAcrescimo = 1;
    private Short tipoPedido = 0;
    private Short statusPedido = 0;
    private Empresa empresa;

    @Id
    @Column(nullable=false, name="ID_ITEM_PEDIDO_COMERCIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_PEDIDO_COMERCIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=4)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_ITEM_PEDIDO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_SIT_IT_PEDID"))
    public SituacaoItemPedido getSituacaoItemPedido() {
        return this.situacaoItemPedido;
    }

    public void setSituacaoItemPedido(SituacaoItemPedido situacaoItemPedido) {
        this.situacaoItemPedido = situacaoItemPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_COMERCIO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_PED_COMERCIO"))
    public PedidoComercio getPedidoComercio() {
        return this.pedidoComercio;
    }

    public void setPedidoComercio(PedidoComercio pedidoComercio) {
        this.pedidoComercio = pedidoComercio;
    }

    @Column(name="NR_ITEM_PEDIDO")
    public Short getNrItemPedido() {
        return this.nrItemPedido;
    }

    public void setNrItemPedido(Short nrItemPedido) {
        this.nrItemPedido = nrItemPedido;
    }

    @Column(name="PERCENTUAL_DESCONTO", precision=15, scale=4)
    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(name="VALOR_TOTAL_BRUTO", precision=15, scale=2)
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    @Column(name="VALOR_ACRESCIMO", precision=15, scale=2)
    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public void setValorAcrescimo(Double valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
    }

    @Column(name="PERC_ACRESCIMO", precision=15, scale=4)
    public Double getPercAcrescimo() {
        return this.percAcrescimo;
    }

    public void setPercAcrescimo(Double percAcrescimo) {
        this.percAcrescimo = percAcrescimo;
    }

    @Column(name="ITEM_CANCELADO")
    public Short getItemCancelado() {
        return this.itemCancelado;
    }

    public void setItemCancelado(Short itemCancelado) {
        this.itemCancelado = itemCancelado;
    }

    @OneToMany(mappedBy="itemPedido", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LogItemPedido> getLogItemPedido() {
        return this.logItemPedido;
    }

    public void setLogItemPedido(List<LogItemPedido> logItemPedido) {
        this.logItemPedido = logItemPedido;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=500)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CANCELAMENTO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COMERCIO_USUARIO"))
    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_REPRES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COMERCIO_GR_COR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_USU_CAD"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @Column(name="VALOR_COMISSAO", precision=15, scale=2)
    public Double getValorComissao() {
        return this.valorComissao;
    }

    public void setValorComissao(Double valorComissao) {
        this.valorComissao = valorComissao;
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COM_CEN_EST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COMERCIO_LT_FAB"))
    @ManyToOne(fetch=FetchType.LAZY)
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Column(name="MOVIMENTAR_ESTOQUE")
    public Short getMovimentarEstoque() {
        return this.movimentarEstoque;
    }

    public void setMovimentarEstoque(Short movimentarEstoque) {
        this.movimentarEstoque = movimentarEstoque;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTACAO")
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Column(name="VLR_TABELA_PRECO", precision=15, scale=4)
    public Double getVlrTabelaPreco() {
        return this.vlrTabelaPreco;
    }

    public void setVlrTabelaPreco(Double vlrTabelaPreco) {
        this.vlrTabelaPreco = vlrTabelaPreco;
    }

    @Column(name="DESCONTO_ITEM")
    public Short getDescontoItem() {
        return this.descontoItem;
    }

    public void setDescontoItem(Short descontoItem) {
        this.descontoItem = descontoItem;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="ACRESCIMO_ITEM")
    public Short getAcrescimoItem() {
        return this.acrescimoItem;
    }

    public void setAcrescimoItem(Short acrescimoItem) {
        this.acrescimoItem = acrescimoItem;
    }

    @Column(name="TIPO_ACRESCIMO")
    public Short getTipoAcrescimo() {
        return this.tipoAcrescimo;
    }

    public void setTipoAcrescimo(Short tipoAcrescimo) {
        this.tipoAcrescimo = tipoAcrescimo;
    }

    @Column(name="TIPO_PEDIDO")
    public Short getTipoPedido() {
        return this.tipoPedido;
    }

    public void setTipoPedido(Short tipoPedido) {
        this.tipoPedido = tipoPedido;
    }

    @Column(name="STATUS_PEDIDO")
    public Short getStatusPedido() {
        return this.statusPedido;
    }

    public void setStatusPedido(Short statusPedido) {
        this.statusPedido = statusPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ITEM_PEDIDO_COMERCIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

