/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.LoteFabRecepcaoXML;
import com.touchcomp.basementor.model.vo.RecepcaoMercadorias;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_RECEPCAO_MERCADORIAS")
public class ItemRecepcaoMercadorias
implements InterfaceVO {
    private Long identificador;
    private ItemOrdemCompra itemOrdemCompra;
    private List<GradeItemRecepcaoMercadorias> gradeItemRecMercadorias = new ArrayList<GradeItemRecepcaoMercadorias>();
    private RecepcaoMercadorias recepcaoMercadoria;
    private List<LoteFabRecepcaoXML> lotesFabRecepcaoXML = new ArrayList<LoteFabRecepcaoXML>();
    private ItemUnidadeMedida itemUnidMedFatorConversao;
    private String descricaoComplementar;
    private String unidadeMedidaXML;

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_REC_MERCADORIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_REC_MERCADORIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_ITEM_RECEPCAO_MERC_IT_ORD_CO"))
    public ItemOrdemCompra getItemOrdemCompra() {
        return this.itemOrdemCompra;
    }

    public void setItemOrdemCompra(ItemOrdemCompra itemOrdemCompra) {
        this.itemOrdemCompra = itemOrdemCompra;
    }

    @OneToMany(mappedBy="itemRecepcaoMercadoria", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GradeItemRecepcaoMercadorias> getGradeItemRecMercadorias() {
        return this.gradeItemRecMercadorias;
    }

    public void setGradeItemRecMercadorias(List<GradeItemRecepcaoMercadorias> gradeItemRecMercadorias) {
        this.gradeItemRecMercadorias = gradeItemRecMercadorias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECEPCAO_MERCADORIA", foreignKey=@ForeignKey(name="FK_ITEM_RECEPCAO_MERC_REC_MERCA"))
    public RecepcaoMercadorias getRecepcaoMercadoria() {
        return this.recepcaoMercadoria;
    }

    public void setRecepcaoMercadoria(RecepcaoMercadorias recepcaoMercadoria) {
        this.recepcaoMercadoria = recepcaoMercadoria;
    }

    @Transient
    public double getQuantidadeTotal() {
        double qtd = 0.0;
        Iterator<GradeItemRecepcaoMercadorias> iterator = this.getGradeItemRecMercadorias().iterator();
        while (iterator.hasNext()) {
            GradeItemRecepcaoMercadorias o;
            GradeItemRecepcaoMercadorias g = o = iterator.next();
            qtd += g.getQuantidade().doubleValue();
        }
        return qtd;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="itemRecepcaoMercadorias", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<LoteFabRecepcaoXML> getLotesFabRecepcaoXML() {
        return this.lotesFabRecepcaoXML;
    }

    public void setLotesFabRecepcaoXML(List<LoteFabRecepcaoXML> lotesFabRecepcaoXML) {
        this.lotesFabRecepcaoXML = lotesFabRecepcaoXML;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_UNID_MED_FAT_CONV", foreignKey=@ForeignKey(name="FK_ITEM_RECEPCAO_MERC_IT_UN_MED"))
    public ItemUnidadeMedida getItemUnidMedFatorConversao() {
        return this.itemUnidMedFatorConversao;
    }

    public void setItemUnidMedFatorConversao(ItemUnidadeMedida itemUnidMedFatorConversao) {
        this.itemUnidMedFatorConversao = itemUnidMedFatorConversao;
    }

    @Column(name="DESCRICAO_COMPLEMENTAR", length=120)
    public String getDescricaoComplementar() {
        return this.descricaoComplementar;
    }

    public void setDescricaoComplementar(String descricaoComplementar) {
        this.descricaoComplementar = descricaoComplementar;
    }

    @Column(name="UNIDADE_MEDIDA_XML", length=10)
    public String getUnidadeMedidaXML() {
        return this.unidadeMedidaXML;
    }

    public void setUnidadeMedidaXML(String unidadeMedidaXML) {
        this.unidadeMedidaXML = unidadeMedidaXML;
    }
}

