/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.CadastroNacionalObra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_REINF_2020")
public class ItemReinf2020
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private ApuracaoReinf apuracaoReinf;
    private Pessoa pessoa;
    private List<ItemReinfNotas2020> itens = new ArrayList<ItemReinfNotas2020>();
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();
    private Short indicadorObra = 0;
    private Short indicadorEmpreitada = 0;
    private CadastroNacionalObra cno;
    private Empresa empresa;

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_REINF_2020")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_REINF_2020")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ITEM_REINF_2020_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_REINF", foreignKey=@ForeignKey(name="FK_ITEM_REINF_2020_APUR_REINF"))
    public ApuracaoReinf getApuracaoReinf() {
        return this.apuracaoReinf;
    }

    public void setApuracaoReinf(ApuracaoReinf apuracaoReinf) {
        this.apuracaoReinf = apuracaoReinf;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="itemReinf2020", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinfNotas2020> getItens() {
        return this.itens;
    }

    public void setItens(List<ItemReinfNotas2020> itens) {
        this.itens = itens;
    }

    @Override
    @OneToMany(mappedBy="itemReinf2020", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }

    @Column(name="INDICADOR_OBRA")
    public Short getIndicadorObra() {
        return this.indicadorObra;
    }

    public void setIndicadorObra(Short indicadorObra) {
        this.indicadorObra = indicadorObra;
    }

    @Column(name="INDICADOR_EMPREITADA")
    public Short getIndicadorEmpreitada() {
        return this.indicadorEmpreitada;
    }

    public void setIndicadorEmpreitada(Short indicadorEmpreitada) {
        this.indicadorEmpreitada = indicadorEmpreitada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_NACIONAL_OBRA", foreignKey=@ForeignKey(name="FK_ITEM_REINF_2020_CNO"))
    public CadastroNacionalObra getCno() {
        return this.cno;
    }

    public void setCno(CadastroNacionalObra cno) {
        this.cno = cno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ITEM_REINF_2020_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

