/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.PacoteOrcamentario;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;

@Entity
@Table(name="JUSTIFIC_PLANEJ_ORCAMENTARIO")
public class JustificativaPlanejamentoOrcamentario
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="IDENTIFICADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_JUSTIFIC_PLANEJ_ORCAMENTARI")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", nullable=true, unique=false)
    private Usuario usuario;
    @JoinColumn(name="ID_PACOTE_ORCAMENTARIO", nullable=true, unique=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private PacoteOrcamentario pacoteOrcamentario;
    @JoinColumn(name="ID_PERIODO_ANALISE", nullable=true, unique=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private IntervaloControleGerPer periodoAnalise;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_GERENCIAL", nullable=true, unique=false)
    private PlanoContaGerencial contaGerencial;
    @Column(name="OBSERVACAO", nullable=true, unique=false, length=500)
    private String observacao;
    @Column(name="VALOR_JUSTIFICAR", nullable=true, unique=false, precision=15, scale=2)
    private Double valorJustificar;
    @Column(name="VALOR_PLANEJADO", nullable=true, unique=false, precision=15, scale=2)
    private Double valorPlanejado;
    @Column(name="VALOR_ORCADO", nullable=true, unique=false, precision=15, scale=2)
    private Double valorOrcado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", unique=false)
    private CentroCusto centroCusto;

    public JustificativaPlanejamentoOrcamentario() {
        this.setValorJustificar(0.0);
        this.setValorOrcado(0.0);
        this.setValorPlanejado(0.0);
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setPacoteOrcamentario(PacoteOrcamentario pacoteOrcamentario) {
        this.pacoteOrcamentario = pacoteOrcamentario;
    }

    @Generated
    public void setPeriodoAnalise(IntervaloControleGerPer periodoAnalise) {
        this.periodoAnalise = periodoAnalise;
    }

    @Generated
    public void setContaGerencial(PlanoContaGerencial contaGerencial) {
        this.contaGerencial = contaGerencial;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setValorJustificar(Double valorJustificar) {
        this.valorJustificar = valorJustificar;
    }

    @Generated
    public void setValorPlanejado(Double valorPlanejado) {
        this.valorPlanejado = valorPlanejado;
    }

    @Generated
    public void setValorOrcado(Double valorOrcado) {
        this.valorOrcado = valorOrcado;
    }

    @Generated
    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public PacoteOrcamentario getPacoteOrcamentario() {
        return this.pacoteOrcamentario;
    }

    @Generated
    public IntervaloControleGerPer getPeriodoAnalise() {
        return this.periodoAnalise;
    }

    @Generated
    public PlanoContaGerencial getContaGerencial() {
        return this.contaGerencial;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Double getValorJustificar() {
        return this.valorJustificar;
    }

    @Generated
    public Double getValorPlanejado() {
        return this.valorPlanejado;
    }

    @Generated
    public Double getValorOrcado() {
        return this.valorOrcado;
    }

    @Generated
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }
}

