/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocMotivoAfastamento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTipoAcidenteTrabalho;
import com.touchcomp.basementor.model.vo.ItemIntegracaoAtestadoFolha;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LANCAMENTO_ATESTADO")
public class LancamentoAtestado
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Colaborador colaborador;
    private String observacoes = "";
    private ArquivamentoDoc arquivamentoDoc;
    private Short integradoFolha = 0;
    private List<ItemIntegracaoAtestadoFolha> itensIntegracaoAtestado;
    private Date dataInicio;
    private Date dataFinal;
    private EsocMotivoAfastamento esocMotivoAfastamento;
    private EsocTipoAcidenteTrabalho esocTipoAcidente;
    private String codigoCid;
    private Integer qtdadeDiasConcedidos = 0;
    private String orgaoClasse;
    private UnidadeFederativa estadoOrgaoClasse;
    private String medico = "";
    private Short tipoOrgao = 1;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();

    public LancamentoAtestado() {
        this.itensIntegracaoAtestado = new ArrayList<ItemIntegracaoAtestadoFolha>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_LANCAMENTO_ATESTADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_ATESTADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_ATESTADO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_LANCAMENTO_ATESTADO_COLAB"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="MEDICO", length=100)
    public String getMedico() {
        return this.medico;
    }

    public void setMedico(String medico) {
        this.medico = medico;
    }

    @Column(name="OBSERVACOES", length=500)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FEDERATIVA_CLASSE", foreignKey=@ForeignKey(name="FK_LANCAMENTO_ATESTADO_UF_CLA"))
    public UnidadeFederativa getEstadoOrgaoClasse() {
        return this.estadoOrgaoClasse;
    }

    public void setEstadoOrgaoClasse(UnidadeFederativa estadoOrgaoClasse) {
        this.estadoOrgaoClasse = estadoOrgaoClasse;
    }

    @JoinColumn(name="ID_ARQUIVAMENTO_DOC", foreignKey=@ForeignKey(name="FK_LANCAMENTO_ATESTADO_ARQ_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivamentoDoc() {
        return this.arquivamentoDoc;
    }

    public void setArquivamentoDoc(ArquivamentoDoc arquivamentoDoc) {
        this.arquivamentoDoc = arquivamentoDoc;
    }

    @Column(name="INTEGRADO_FOLHA")
    public Short getIntegradoFolha() {
        return this.integradoFolha;
    }

    public void setIntegradoFolha(Short integradoFolha) {
        this.integradoFolha = integradoFolha;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="lancamento", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemIntegracaoAtestadoFolha> getItensIntegracaoAtestado() {
        return this.itensIntegracaoAtestado;
    }

    public void setItensIntegracaoAtestado(List<ItemIntegracaoAtestadoFolha> itensIntegracaoAtestado) {
        this.itensIntegracaoAtestado = itensIntegracaoAtestado;
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Override
    @OneToMany(mappedBy="lancamentoAtestado")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_MOT_AFASTAMENTO", foreignKey=@ForeignKey(name="FK_ATESTADO_MOT_AFASTAMENTO"))
    public EsocMotivoAfastamento getEsocMotivoAfastamento() {
        return this.esocMotivoAfastamento;
    }

    public void setEsocMotivoAfastamento(EsocMotivoAfastamento esocMotivoAfastamento) {
        this.esocMotivoAfastamento = esocMotivoAfastamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_TP_ACIDENTE", foreignKey=@ForeignKey(name="FK_ATESTADO_ESOC_TP_ACIDENTE"))
    public EsocTipoAcidenteTrabalho getEsocTipoAcidente() {
        return this.esocTipoAcidente;
    }

    public void setEsocTipoAcidente(EsocTipoAcidenteTrabalho esocTipoAcidente) {
        this.esocTipoAcidente = esocTipoAcidente;
    }

    @Column(name="CODIGO_CID", length=10)
    public String getCodigoCid() {
        return this.codigoCid;
    }

    public void setCodigoCid(String codigoCid) {
        this.codigoCid = codigoCid;
    }

    @Column(name="QTDADE_DIAS_CONCEDIDOS")
    public Integer getQtdadeDiasConcedidos() {
        return this.qtdadeDiasConcedidos;
    }

    public void setQtdadeDiasConcedidos(Integer qtdadeDiasConcedidos) {
        this.qtdadeDiasConcedidos = qtdadeDiasConcedidos;
    }

    @Column(name="ORGAO_CLASSE", length=25)
    public String getOrgaoClasse() {
        return this.orgaoClasse;
    }

    public void setOrgaoClasse(String orgaoClasse) {
        this.orgaoClasse = orgaoClasse;
    }

    @Column(name="TIPO_ORGAO")
    public Short getTipoOrgao() {
        return this.tipoOrgao;
    }

    public void setTipoOrgao(Short tipoOrgao) {
        this.tipoOrgao = tipoOrgao;
    }
}

