/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LANC_COMISSAO_REP")
public class LancamentoComissaoRepresentante
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Representante representante;
    private Date dataLancamento;
    private Double valor = 0.0;
    private Short debCred = 1;
    private String observacao;
    private ApuracaoComissaoRepresentante apuracaoComissaoRepresentante;
    private Short gerarMovimentoBancario = 0;
    private MovimentoBancario movimentoBancario;

    @Id
    @Column(name="ID_LANC_COMISSAO_REP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANC_COMISSAO_REP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANC_COMISSAO_REP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_LANC_COMISSAO_REP_REPRES"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LANCAMENTO")
    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="OBSERVACAO", length=2000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_COMISSAO_REP", foreignKey=@ForeignKey(name="FK_LANC_COMISSAO_REP_APUR"))
    public ApuracaoComissaoRepresentante getApuracaoComissaoRepresentante() {
        return this.apuracaoComissaoRepresentante;
    }

    public void setApuracaoComissaoRepresentante(ApuracaoComissaoRepresentante apuracaoComissaoRepresentante) {
        this.apuracaoComissaoRepresentante = apuracaoComissaoRepresentante;
    }

    @Column(name="DEB_CRED")
    public Short getDebCred() {
        return this.debCred;
    }

    public void setDebCred(Short debCred) {
        this.debCred = debCred;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getRepresentante() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getRepresentante()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="GERAR_MOVIMENTO_BANCARIO")
    public Short getGerarMovimentoBancario() {
        return this.gerarMovimentoBancario;
    }

    public void setGerarMovimentoBancario(Short gerarMovimentoBancario) {
        this.gerarMovimentoBancario = gerarMovimentoBancario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN, CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_MOVIMENTO_BANCARIO", foreignKey=@ForeignKey(name="FK_LANC_COMISSAO_REP_MOV_BANC"))
    public MovimentoBancario getMovimentoBancario() {
        return this.movimentoBancario;
    }

    public void setMovimentoBancario(MovimentoBancario movimentoBancario) {
        this.movimentoBancario = movimentoBancario;
    }
}

