/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="LANCAMENTO_FLUXO_CAIXA")
public class LancamentoFluxoCaixa
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataEmissao;
    private Date dataCadastro;
    private String descricao;
    private String observacao;
    private Date dataVencimentoInicial;
    private Date dataVencimentoFinal;
    private Short tipoDataVencimento = 0;
    private Short pagRec = 0;
    private Short provisao = 0;
    private Double valor = 0.0;
    private PlanoContaGerencial contaGerencial;
    private Integer diaBaseVencimento = 0;

    @Id
    @Column(nullable=false, name="ID_LANCAMENTO_FLUXO_CAIXA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_FLUXO_CAIXA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FLUXO_CAIXA_EMPRE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="OBSERVACAO", length=150)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DATA_VENCIMENTO_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    public void setDataVencimentoInicial(Date dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Column(name="DATA_VENCIMENTO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    public void setDataVencimentoFinal(Date dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Column(name="TIPO_DATA_VENCIMENTO")
    public Short getTipoDataVencimento() {
        return this.tipoDataVencimento;
    }

    public void setTipoDataVencimento(Short tipoDataVencimento) {
        this.tipoDataVencimento = tipoDataVencimento;
    }

    @Column(name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Column(name="PROVISAO")
    public Short getProvisao() {
        return this.provisao;
    }

    public void setProvisao(Short provisao) {
        this.provisao = provisao;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=4)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FLUXO_CAIXA_CONTA"))
    public PlanoContaGerencial getContaGerencial() {
        return this.contaGerencial;
    }

    public void setContaGerencial(PlanoContaGerencial contaGerencial) {
        this.contaGerencial = contaGerencial;
    }

    @Column(name="DIA_BASE_VENCIMENTO")
    public Integer getDiaBaseVencimento() {
        return this.diaBaseVencimento;
    }

    public void setDiaBaseVencimento(Integer diaBaseVencimento) {
        this.diaBaseVencimento = diaBaseVencimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

