/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoFreteAdiantamentoTranspAgregado;
import com.touchcomp.basementor.model.vo.LancamentoFreteCte;
import com.touchcomp.basementor.model.vo.LancamentoFreteOcorrencias;
import com.touchcomp.basementor.model.vo.LancamentoFreteStatus;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RotaClientePedido;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LANCAMENTO_FRETE")
public class LancamentoFrete
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private RotaClientePedido rotaClientePedido;
    private String placa;
    private Pessoa motorista;
    private Double km = 0.0;
    private Double valorKm = 0.0;
    private Double valorPedagio = 0.0;
    private Double valorBalsa = 0.0;
    private Double valorOutrasDespespesas = 0.0;
    private Double valorRedespacho = 0.0;
    private Double valorFrete = 0.0;
    private Double valorCarga = 0.0;
    private Double valorCubagem = 0.0;
    private Date dataSaida;
    private Date dataRetorno;
    private Integer quantidadeCidades = 0;
    private Integer quantidadeEntregas = 0;
    private Double valorAdiantamento = 0.0;
    private Double valorAbastecimento = 0.0;
    private Double valorEmissaoCte = 0.0;
    private Double valorAcerto = 0.0;
    private List<LancamentoFreteOcorrencias> lancamentoOcorrencia = new ArrayList<LancamentoFreteOcorrencias>();
    private List<LancamentoFreteCte> ctes = new ArrayList<LancamentoFreteCte>();
    private Transportador transportador;
    private String observacaoMotorista;
    private Date dataFechamento;
    private LancamentoFreteStatus statusLancamento;
    private List<LancamentoFreteAdiantamentoTranspAgregado> lancamentoFreteAdiantamentoTranspAgregado = new ArrayList<LancamentoFreteAdiantamentoTranspAgregado>();
    private Double valorFreteCalcTab = 0.0;

    @Id
    @Column(nullable=false, name="ID_LANCAMENTO_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FRETE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTA_CLIENTE_PEDIDO", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FRETE_ROTA"))
    public RotaClientePedido getRotaClientePedido() {
        return this.rotaClientePedido;
    }

    public void setRotaClientePedido(RotaClientePedido rotaClientePedido) {
        this.rotaClientePedido = rotaClientePedido;
    }

    @Column(name="PLACA", length=8)
    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FRETE_MOTORISTA"))
    public Pessoa getMotorista() {
        return this.motorista;
    }

    public void setMotorista(Pessoa motorista) {
        this.motorista = motorista;
    }

    @Column(nullable=false, name="KM", precision=15, scale=2)
    public Double getKm() {
        return this.km;
    }

    public void setKm(Double km) {
        this.km = km;
    }

    @Column(nullable=false, name="VALOR_KM", precision=15, scale=2)
    public Double getValorKm() {
        return this.valorKm;
    }

    public void setValorKm(Double valorKm) {
        this.valorKm = valorKm;
    }

    @Column(nullable=false, name="VALOR_PEDAGIO", precision=15, scale=2)
    public Double getValorPedagio() {
        return this.valorPedagio;
    }

    public void setValorPedagio(Double valorPedagio) {
        this.valorPedagio = valorPedagio;
    }

    @Column(nullable=false, name="VALOR_BALSA", precision=15, scale=2)
    public Double getValorBalsa() {
        return this.valorBalsa;
    }

    public void setValorBalsa(Double valorBalsa) {
        this.valorBalsa = valorBalsa;
    }

    @Column(nullable=false, name="VALOR_OUTRAS_DESPESPESAS", precision=15, scale=2)
    public Double getValorOutrasDespespesas() {
        return this.valorOutrasDespespesas;
    }

    public void setValorOutrasDespespesas(Double valorOutrasDespespesas) {
        this.valorOutrasDespespesas = valorOutrasDespespesas;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(nullable=false, name="VALOR_REDESPACHO", precision=15, scale=2)
    public Double getValorRedespacho() {
        return this.valorRedespacho;
    }

    public void setValorRedespacho(Double valorRedespacho) {
        this.valorRedespacho = valorRedespacho;
    }

    @Column(nullable=false, name="VALOR_CARGA", precision=15, scale=2)
    public Double getValorCarga() {
        return this.valorCarga;
    }

    public void setValorCarga(Double valorCarga) {
        this.valorCarga = valorCarga;
    }

    @Column(nullable=false, name="VALOR_CUBAGEM", precision=15, scale=2)
    public Double getValorCubagem() {
        return this.valorCubagem;
    }

    public void setValorCubagem(Double valorCubagem) {
        this.valorCubagem = valorCubagem;
    }

    @Column(name="DATA_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataSaida() {
        return this.dataSaida;
    }

    public void setDataSaida(Date dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Column(name="DATA_RETORNO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @Column(name="DATA_FECHAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Column(nullable=false, name="QUANTIDADE_CIDADES")
    public Integer getQuantidadeCidades() {
        return this.quantidadeCidades;
    }

    public void setQuantidadeCidades(Integer quantidadeCidades) {
        this.quantidadeCidades = quantidadeCidades;
    }

    @Column(nullable=false, name="QUANTIDADE_ENTREGAS")
    public Integer getQuantidadeEntregas() {
        return this.quantidadeEntregas;
    }

    public void setQuantidadeEntregas(Integer quantidadeEntregas) {
        this.quantidadeEntregas = quantidadeEntregas;
    }

    @Column(nullable=false, name="VALOR_ADIANTAMENTO", precision=15, scale=2)
    public Double getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    public void setValorAdiantamento(Double valorAdiantamento) {
        this.valorAdiantamento = valorAdiantamento;
    }

    @Column(nullable=false, name="VALOR_ABASTECIMENTO", precision=15, scale=2)
    public Double getValorAbastecimento() {
        return this.valorAbastecimento;
    }

    public void setValorAbastecimento(Double valorAbastecimento) {
        this.valorAbastecimento = valorAbastecimento;
    }

    @Column(nullable=false, name="VALOR_EMISSAO_CTE", precision=15, scale=2)
    public Double getValorEmissaoCte() {
        return this.valorEmissaoCte;
    }

    public void setValorEmissaoCte(Double valorEmissaoCte) {
        this.valorEmissaoCte = valorEmissaoCte;
    }

    @Column(nullable=false, name="VALOR_ACERTO", precision=15, scale=2)
    public Double getValorAcerto() {
        return this.valorAcerto;
    }

    public void setValorAcerto(Double valorAcerto) {
        this.valorAcerto = valorAcerto;
    }

    @OneToMany(mappedBy="lancamentoFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LancamentoFreteOcorrencias> getLancamentoOcorrencia() {
        return this.lancamentoOcorrencia;
    }

    public void setLancamentoOcorrencia(List<LancamentoFreteOcorrencias> lancamentoOcorrencia) {
        this.lancamentoOcorrencia = lancamentoOcorrencia;
    }

    @OneToMany(mappedBy="lancamentoFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LancamentoFreteCte> getCtes() {
        return this.ctes;
    }

    public void setCtes(List<LancamentoFreteCte> ctes) {
        this.ctes = ctes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FRETE_TRANSP"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @Column(name="OBSERVACAO_MOTORISTA", length=250)
    public String getObservacaoMotorista() {
        return this.observacaoMotorista;
    }

    public void setObservacaoMotorista(String observacaoMotorista) {
        this.observacaoMotorista = observacaoMotorista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_LANCAMENTO", foreignKey=@ForeignKey(name="FK_LANCAMENTO_FRETE_STATUS"))
    public LancamentoFreteStatus getStatusLancamento() {
        return this.statusLancamento;
    }

    public void setStatusLancamento(LancamentoFreteStatus statusLancamento) {
        this.statusLancamento = statusLancamento;
    }

    @OneToMany(mappedBy="lancamentoFrete", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LancamentoFreteAdiantamentoTranspAgregado> getLancamentoFreteAdiantamentoTranspAgregado() {
        return this.lancamentoFreteAdiantamentoTranspAgregado;
    }

    public void setLancamentoFreteAdiantamentoTranspAgregado(List<LancamentoFreteAdiantamentoTranspAgregado> lancamentoFreteAdiantamentoTranspAgregado) {
        this.lancamentoFreteAdiantamentoTranspAgregado = lancamentoFreteAdiantamentoTranspAgregado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getRotaClientePedido() != null ? this.getRotaClientePedido().toString() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_FRETE_CALC_TAB")
    public Double getValorFreteCalcTab() {
        return this.valorFreteCalcTab;
    }

    public void setValorFreteCalcTab(Double valorFreteCalcTab) {
        this.valorFreteCalcTab = valorFreteCalcTab;
    }
}

