/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.ProcessoFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="LANCAMENTO_SPED_PIS_COFINS")
public class LancamentoSpedPisCofins
implements InterfaceVO {
    private Long identificador;
    private Lancamento lancamento;
    private Short indOper = 0;
    private Pessoa participante;
    private Produto produto;
    private Date dataOper;
    private Double vrOper = 0.0;
    private IncidenciaPisCofins cstPis;
    private IncidenciaPisCofins cstCofins;
    private Double vrBcPis = 0.0;
    private Double vrBcCofins = 0.0;
    private Double aliqPis = 0.0;
    private Double aliqCofins = 0.0;
    private Double vrPis = 0.0;
    private Double vrCofins = 0.0;
    private NaturezaBCCredito natBcCredito;
    private Short indOrigCred = 0;
    private PlanoConta planoConta;
    private CentroCusto centroCusto;
    private String descDocOper;
    private ProcessoFiscal processoFiscal;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private ItemNotaTerceiros itemNotaOrigemTerc;
    private ItemNotaFiscalPropria itemNotaOrigemProp;

    @Id
    @Column(unique=true, name="ID_LANCAMENTO_SPED_PIS_COFINS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_SPED_PIS_COFINS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToOne(targetEntity=Lancamento.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANCAMENTO", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_LANCAME"))
    public Lancamento getLancamento() {
        return this.lancamento;
    }

    public void setLancamento(Lancamento lancamento) {
        this.lancamento = lancamento;
    }

    @Column(name="IND_OPER")
    public Short getIndOper() {
        return this.indOper;
    }

    public void setIndOper(Short indOper) {
        this.indOper = indOper;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_PESSOA"))
    public Pessoa getParticipante() {
        return this.participante;
    }

    public void setParticipante(Pessoa participante) {
        this.participante = participante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_OPER")
    public Date getDataOper() {
        return this.dataOper;
    }

    public void setDataOper(Date dataOper) {
        this.dataOper = dataOper;
    }

    @Column(name="VR_OPER", precision=12, scale=2)
    public Double getVrOper() {
        return this.vrOper;
    }

    public void setVrOper(Double vrOper) {
        this.vrOper = vrOper;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CST_PIS", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_CST_PIS"))
    public IncidenciaPisCofins getCstPis() {
        return this.cstPis;
    }

    public void setCstPis(IncidenciaPisCofins cstPis) {
        this.cstPis = cstPis;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CST_COFINS", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_CST_COF"))
    public IncidenciaPisCofins getCstCofins() {
        return this.cstCofins;
    }

    public void setCstCofins(IncidenciaPisCofins cstCofins) {
        this.cstCofins = cstCofins;
    }

    @Column(name="VR_BC_PIS", precision=12, scale=2)
    public Double getVrBcPis() {
        return this.vrBcPis;
    }

    public void setVrBcPis(Double vrBcPis) {
        this.vrBcPis = vrBcPis;
    }

    @Column(name="VR_BC_COFINS", precision=12, scale=2)
    public Double getVrBcCofins() {
        return this.vrBcCofins;
    }

    public void setVrBcCofins(Double vrBcCofins) {
        this.vrBcCofins = vrBcCofins;
    }

    @Column(name="ALIQ_PIS", precision=12, scale=2)
    public Double getAliqPis() {
        return this.aliqPis;
    }

    public void setAliqPis(Double aliqPis) {
        this.aliqPis = aliqPis;
    }

    @Column(name="ALIQ_COFINS", precision=12, scale=2)
    public Double getAliqCofins() {
        return this.aliqCofins;
    }

    public void setAliqCofins(Double aliqCofins) {
        this.aliqCofins = aliqCofins;
    }

    @Column(name="VR_PIS", precision=12, scale=2)
    public Double getVrPis() {
        return this.vrPis;
    }

    public void setVrPis(Double vrPis) {
        this.vrPis = vrPis;
    }

    @Column(name="VR_COFINS", precision=12, scale=2)
    public Double getVrCofins() {
        return this.vrCofins;
    }

    public void setVrCofins(Double vrCofins) {
        this.vrCofins = vrCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_BC_CREDITO", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_NAT_BC"))
    public NaturezaBCCredito getNatBcCredito() {
        return this.natBcCredito;
    }

    public void setNatBcCredito(NaturezaBCCredito natBcCredito) {
        this.natBcCredito = natBcCredito;
    }

    @Column(name="IND_ORIG_CRED")
    public Short getIndOrigCred() {
        return this.indOrigCred;
    }

    public void setIndOrigCred(Short indOrigCred) {
        this.indOrigCred = indOrigCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_PLAN_CO"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_CEN_CUS"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="DESC_DOC_OPER", length=500)
    public String getDescDocOper() {
        return this.descDocOper;
    }

    public void setDescDocOper(String descDocOper) {
        this.descDocOper = descDocOper;
    }

    @JoinColumn(name="ID_PROCESSO_FISCAL", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_PROC_FI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ProcessoFiscal getProcessoFiscal() {
        return this.processoFiscal;
    }

    public void setProcessoFiscal(ProcessoFiscal processoFiscal) {
        this.processoFiscal = processoFiscal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescDocOper() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescDocOper()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_ORIG_TERC", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_IT_TERC"))
    public ItemNotaTerceiros getItemNotaOrigemTerc() {
        return this.itemNotaOrigemTerc;
    }

    public void setItemNotaOrigemTerc(ItemNotaTerceiros itemNotaOrigemTerc) {
        this.itemNotaOrigemTerc = itemNotaOrigemTerc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_ORIG_PROP", foreignKey=@ForeignKey(name="FK_LANC_SPED_PIS_COFINS_IT_PR"))
    public ItemNotaFiscalPropria getItemNotaOrigemProp() {
        return this.itemNotaOrigemProp;
    }

    public void setItemNotaOrigemProp(ItemNotaFiscalPropria itemNotaOrigemProp) {
        this.itemNotaOrigemProp = itemNotaOrigemProp;
    }
}

