/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemLiberacaoMTC;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LIBERACAO_MTC")
public class LiberacaoMTC
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Pedido pedido;
    private Double percFrete = 0.0;
    private Double percDesconto = 0.0;
    private Short politicaPreco = 0;
    private Double valorTotalPedido = 0.0;
    private Double valorTotalComImposto = 0.0;
    private Double valorTotalCusto = 0.0;
    private Double valorLucroBruto = 0.0;
    private Double mtcBruto = 0.0;
    private Double valorComissao = 0.0;
    private Double valorFrete = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorOperacional = 0.0;
    private Double valorTotalOperacional = 0.0;
    private Double valorLucroLiquido = 0.0;
    private Double mtcLiquido = 0.0;
    private List<ItemLiberacaoMTC> itensLiberacao = new ArrayList<ItemLiberacaoMTC>();

    @Id
    @Column(name="ID_LIBERACAO_MTC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LIBERACAO_MTC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LIBERACAO_MTC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_LIBERACAO_MTC_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @Column(name="PERC_FRETE", precision=15, scale=6)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(name="POLITICA_PRECO")
    public Short getPoliticaPreco() {
        return this.politicaPreco;
    }

    public void setPoliticaPreco(Short politicaPreco) {
        this.politicaPreco = politicaPreco;
    }

    @Column(nullable=false, name="VALOR_TOTAL_PEDIDO", precision=15, scale=2)
    public Double getValorTotalPedido() {
        return this.valorTotalPedido;
    }

    public void setValorTotalPedido(Double valorTotalPedido) {
        this.valorTotalPedido = valorTotalPedido;
    }

    @Column(nullable=false, name="VALOR_TOTAL_CUSTO", precision=15, scale=2)
    public Double getValorTotalCusto() {
        return this.valorTotalCusto;
    }

    public void setValorTotalCusto(Double valorTotalCusto) {
        this.valorTotalCusto = valorTotalCusto;
    }

    @Column(name="VALOR_LUCRO_BRUTO", precision=15, scale=2)
    public Double getValorLucroBruto() {
        return this.valorLucroBruto;
    }

    public void setValorLucroBruto(Double valorLucroBruto) {
        this.valorLucroBruto = valorLucroBruto;
    }

    @Column(name="MTC_BRUTO", precision=15, scale=6)
    public Double getMtcBruto() {
        return this.mtcBruto;
    }

    public void setMtcBruto(Double mtcBruto) {
        this.mtcBruto = mtcBruto;
    }

    @Column(name="VALOR_COMISSAO", precision=15, scale=2)
    public Double getValorComissao() {
        return this.valorComissao;
    }

    public void setValorComissao(Double valorComissao) {
        this.valorComissao = valorComissao;
    }

    @Column(name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(name="VALOR_OPERACIONAL", precision=15, scale=2)
    public Double getValorOperacional() {
        return this.valorOperacional;
    }

    public void setValorOperacional(Double valorOperacional) {
        this.valorOperacional = valorOperacional;
    }

    @Column(nullable=false, name="VALOR_TOTAL_OPERACIONAL", precision=15, scale=2)
    public Double getValorTotalOperacional() {
        return this.valorTotalOperacional;
    }

    public void setValorTotalOperacional(Double valorTotalOperacional) {
        this.valorTotalOperacional = valorTotalOperacional;
    }

    @Column(nullable=false, name="VALOR_LUCRO_LIQUIDO", precision=15, scale=2)
    public Double getValorLucroLiquido() {
        return this.valorLucroLiquido;
    }

    public void setValorLucroLiquido(Double valorLucroLiquido) {
        this.valorLucroLiquido = valorLucroLiquido;
    }

    @Column(nullable=false, name="MTC_LIQUIDO", precision=15, scale=6)
    public Double getMtcLiquido() {
        return this.mtcLiquido;
    }

    public void setMtcLiquido(Double mtcLiquido) {
        this.mtcLiquido = mtcLiquido;
    }

    @OneToMany(mappedBy="liberacaoMTC", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemLiberacaoMTC> getItensLiberacao() {
        return this.itensLiberacao;
    }

    public void setItensLiberacao(List<ItemLiberacaoMTC> itensLiberacao) {
        this.itensLiberacao = itensLiberacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR_TOTAL_IMPOSTO", precision=15, scale=2)
    public Double getValorTotalComImposto() {
        return this.valorTotalComImposto;
    }

    public void setValorTotalComImposto(Double valorTotalComImposto) {
        this.valorTotalComImposto = valorTotalComImposto;
    }

    @Column(name="PERC_DESCONTO", precision=15, scale=6)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }
}

