/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.liberacaoordemcompra.ConstEnumLiberacaoOrdemCompra;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="LIBERACAO_ORDEM_COMPRA")
public class LiberacaoOrdemCompra
implements InterfaceVO {
    private Long identificador;
    private Usuario usuario;
    private OrdemCompra ordemCompra;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private BigInteger identificadorLibMobile;
    private Short liberado = 0;
    private Short tipoLiberacaoOC;
    private List<LiberacaoOrdemCompraItem> itens = new ArrayList<LiberacaoOrdemCompraItem>();

    public LiberacaoOrdemCompra() {
        this.tipoLiberacaoOC = ConstEnumLiberacaoOrdemCompra.TIPO_LIBERACAO_NENHUM.value;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getUsuario() != null ? this.getUsuario() : this.getUsuario()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Id
    @Column(name="ID_LIBERACAO_ORDEM_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LIBERACAO_ORDEM_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LIBERACAO_ORDEM_COMP_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="liberacaoOrdemCompra", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public OrdemCompra getOrdemCompra() {
        return this.ordemCompra;
    }

    public void setOrdemCompra(OrdemCompra ordemCompra) {
        this.ordemCompra = ordemCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LIBERACAO_ORDEM_COMP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Ignore
    @Column(name="IDENTIFICADOR_LIB_MOBILE", precision=17, scale=0)
    public BigInteger getIdentificadorLibMobile() {
        return this.identificadorLibMobile;
    }

    public void setIdentificadorLibMobile(BigInteger identificadorLibMobile) {
        this.identificadorLibMobile = identificadorLibMobile;
    }

    @Column(name="LIBERADO")
    public Short getLiberado() {
        return this.liberado;
    }

    public void setLiberado(Short liberado) {
        this.liberado = liberado;
    }

    @OneToMany(mappedBy="liberacaoOrdemCompra", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<LiberacaoOrdemCompraItem> getItens() {
        return this.itens;
    }

    public void setItens(List<LiberacaoOrdemCompraItem> itens) {
        this.itens = itens;
    }

    @Column(name="TIPO_LIBERACAO_OC")
    public Short getTipoLiberacaoOC() {
        return this.tipoLiberacaoOC;
    }

    public void setTipoLiberacaoOC(Short tipoLiberacaoOC) {
        this.tipoLiberacaoOC = tipoLiberacaoOC;
    }
}

