/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.FechamentoColaboradorVT;
import com.touchcomp.basementor.model.vo.ItemLinhaTransporteColaborador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LINHA_TRANSPORTE_FECHAMENTO")
public class LinhaTransporteFechamento
implements InterfaceVO {
    private Long identificador;
    private FechamentoColaboradorVT fechamento;
    private ItemLinhaTransporteColaborador itemLinha;
    private Double diasApuracao;
    private Double saldoCartao;
    private Double valorTotal;
    private Double valorDiario;
    private Double quantidade;
    private Short informarValoresManuais;
    private Double diasApuracaoRecalc;
    private Double saldoCartaoRecalc;
    private Double valorTotalRecalc;
    private Double valorDiarioRecalc;
    private Double quantidadeRecalc;

    public LinhaTransporteFechamento() {
        this.diasApuracao = 0.0;
        this.saldoCartao = 0.0;
        this.valorTotal = 0.0;
        this.valorDiario = 0.0;
        this.quantidade = 0.0;
        this.informarValoresManuais = 0;
        this.diasApuracaoRecalc = 0.0;
        this.saldoCartaoRecalc = 0.0;
        this.valorTotalRecalc = 0.0;
        this.valorDiarioRecalc = 0.0;
        this.quantidadeRecalc = 0.0;
    }

    public LinhaTransporteFechamento(FechamentoColaboradorVT fechamento, ItemLinhaTransporteColaborador itemLinha) {
        this.fechamento = fechamento;
        this.itemLinha = itemLinha;
        this.diasApuracao = fechamento.getQuantidadeDias();
        this.saldoCartao = 0.0;
        this.valorDiario = itemLinha.getLinhaTransporte().getTarifa();
        this.quantidade = itemLinha.getQtdadeDiaria().doubleValue();
        this.valorTotal = itemLinha.getQtdadeDiaria().doubleValue() * fechamento.getQuantidadeDias() * itemLinha.getLinhaTransporte().getTarifa();
        this.informarValoresManuais = 0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_LINHA_FECHAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LINHA_FECHAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAMENTO_VT", foreignKey=@ForeignKey(name="FK_LINHA_FECHAMENTO_VT"))
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public FechamentoColaboradorVT getFechamento() {
        return this.fechamento;
    }

    public void setFechamento(FechamentoColaboradorVT fechamento) {
        this.fechamento = fechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_LINHA", foreignKey=@ForeignKey(name="FK_ITEM_LINHA_FECHAMENTO_VT"))
    public ItemLinhaTransporteColaborador getItemLinha() {
        return this.itemLinha;
    }

    public void setItemLinha(ItemLinhaTransporteColaborador itemLinha) {
        this.itemLinha = itemLinha;
    }

    @Column(name="DIAS_APURACAO", precision=15, scale=4)
    public Double getDiasApuracao() {
        return this.diasApuracao;
    }

    public void setDiasApuracao(Double diasApuracao) {
        this.diasApuracao = diasApuracao;
    }

    @Column(name="SALDO_CARTAO", precision=15, scale=4)
    public Double getSaldoCartao() {
        return this.saldoCartao;
    }

    public void setSaldoCartao(Double saldoCartao) {
        this.saldoCartao = saldoCartao;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=4)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="VALOR_DIARIO", precision=15, scale=4)
    public Double getValorDiario() {
        return this.valorDiario;
    }

    public void setValorDiario(Double valorDiario) {
        this.valorDiario = valorDiario;
    }

    @Column(name="QUANTIDADE", precision=15, scale=4)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INFORMAR_VALORES_MANUAIS")
    public Short getInformarValoresManuais() {
        return this.informarValoresManuais;
    }

    public void setInformarValoresManuais(Short informarValoresManuais) {
        this.informarValoresManuais = informarValoresManuais;
    }

    @Column(name="DIAS_APURACAO_RECALC", precision=15, scale=4)
    public Double getDiasApuracaoRecalc() {
        return this.diasApuracaoRecalc;
    }

    public void setDiasApuracaoRecalc(Double diasApuracaoRecalc) {
        this.diasApuracaoRecalc = diasApuracaoRecalc;
    }

    @Column(name="SALDO_CARTAO_RECALC", precision=15, scale=4)
    public Double getSaldoCartaoRecalc() {
        return this.saldoCartaoRecalc;
    }

    public void setSaldoCartaoRecalc(Double saldoCartaoRecalc) {
        this.saldoCartaoRecalc = saldoCartaoRecalc;
    }

    @Column(name="VALOR_TOTAL_RECALC", precision=15, scale=4)
    public Double getValorTotalRecalc() {
        return this.valorTotalRecalc;
    }

    public void setValorTotalRecalc(Double valorTotalRecalc) {
        this.valorTotalRecalc = valorTotalRecalc;
    }

    @Column(name="VALOR_DIARIO_RECALC", precision=15, scale=4)
    public Double getValorDiarioRecalc() {
        return this.valorDiarioRecalc;
    }

    public void setValorDiarioRecalc(Double valorDiarioRecalc) {
        this.valorDiarioRecalc = valorDiarioRecalc;
    }

    @Column(name="QUANTIDADE_RECALC", precision=15, scale=4)
    public Double getQuantidadeRecalc() {
        return this.quantidadeRecalc;
    }

    public void setQuantidadeRecalc(Double quantidadeRecalc) {
        this.quantidadeRecalc = quantidadeRecalc;
    }
}

