/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LIVRO_FISCAL")
public class LivroFiscal
implements InterfaceVO {
    private Long identificador;
    private Cfop cfop;
    private PlanoConta planoConta;
    private IncidenciaIcms incidenciaIcms;
    private IncidenciaIpi incidenciaIpi;
    private Double aliquotaIcms = 0.0;
    private Double aliqutoaIcmsProduto = 0.0;
    private Double valorIcmsTributado = 0.0;
    private Double valorIcmsIsento = 0.0;
    private Double valorIcmsOutros = 0.0;
    private Double valorIcms = 0.0;
    private Double valorIcmsSemAprov = 0.0;
    private Double valorIcmsDesonerado = 0.0;
    private Double valorBCIcmsSt = 0.0;
    private Double valorIcmsSt = 0.0;
    private Double valorIpiTributado = 0.0;
    private Double valorIpiIsento = 0.0;
    private Double valorIpiOutros = 0.0;
    private Double valorIpiIndustria = 0.0;
    private Double valorIpiComercio = 0.0;
    private Double valorIpiObservacao = 0.0;
    private Double valorInss = 0.0;
    private Double valorIrrf = 0.0;
    private Double valorIss = 0.0;
    private Double valorLei10833 = 0.0;
    private Double valorOutros = 0.0;
    private Double valorFunrural = 0.0;
    private Double valorTotal = 0.0;
    private Double valorPis = 0.0;
    private Double valorCofins = 0.0;
    private Double valorContSocial = 0.0;
    private Date dataLivro;
    private Double valorDifAliquota = 0.0;
    private Double valorSestSenat = 0.0;
    private Double aliquotaCofins = 0.0;
    private Double aliquotaPis = 0.0;
    private Empresa empresa;
    private UnidadeFederativa uf;
    private Short entradaSaidaNaturezaOp = 0;
    private UnidadeFederativa ufIcmsSt;
    private Short cancelado = 0;
    private Double vrNaoTribIcms = 0.0;
    private List<ObservacaoLivroFiscal> obsLivroFiscal = new ArrayList<ObservacaoLivroFiscal>();
    private Double valorFreteIcmsST = 0.0;
    private Double vrBCPis = 0.0;
    private Double vrBCCofins = 0.0;
    private IncidenciaPisCofins incidenciaPis;
    private IncidenciaPisCofins incidenciaCofins;
    private Double aliquotaPisQtde = 0.0;
    private Double aliquotaCofinsQtde = 0.0;
    private Double vrCustoICMSST = 0.0;
    private Double vrBCCustoICMSST = 0.0;
    private Double valorIcmsPartilhaDest = 0.0;
    private Double valorIcmsPartilhaRem = 0.0;
    private Double valorFundoPobreza = 0.0;
    private Cidade cidade;
    private Double aliquotaFCP = 0.0;
    private Double valorFCP = 0.0;
    private Double aliquotaFCPSt = 0.0;
    private Double valorFCPSt = 0.0;
    private Double aliquotaFCPStRetido = 0.0;
    private Double valorFCPStRetido = 0.0;
    private Double valorIpiDevolucao = 0.0;
    private Double valorIcmsDiferimento = 0.0;
    private Short descartarDapi = 0;

    public LivroFiscal() {
    }

    public LivroFiscal(Cfop cfop, PlanoConta planoContaCred, IncidenciaIcms incidenciaIcms, IncidenciaIpi incidenciaIpi, Double aliquotaIcms, Double aliquotaIcmsProd, Date dataLivro, IncidenciaPisCofins incidenciaPis, IncidenciaPisCofins incidenciaCofins, Double aliquotaPis, Double aliquotaCofins, Double aliquotaPisQtde, Double aliquotaCofinsQtde) {
        this();
        this.cfop = cfop;
        this.planoConta = planoContaCred;
        this.incidenciaIcms = incidenciaIcms;
        this.incidenciaIpi = incidenciaIpi;
        this.aliquotaIcms = aliquotaIcms;
        this.aliqutoaIcmsProduto = aliquotaIcmsProd;
        this.dataLivro = dataLivro;
        this.cancelado = 0;
        this.incidenciaPis = incidenciaCofins;
        this.incidenciaCofins = incidenciaPis;
        this.aliquotaPis = aliquotaPis;
        this.aliquotaCofins = aliquotaCofins;
        this.aliquotaPisQtde = aliquotaPisQtde;
        this.aliquotaCofinsQtde = aliquotaCofinsQtde;
        this.descartarDapi = 0;
        this.vrCustoICMSST = 0.0;
        this.vrBCCustoICMSST = 0.0;
        this.obsLivroFiscal = new ArrayList<ObservacaoLivroFiscal>();
        this.aliquotaFCP = 0.0;
        this.valorFCP = 0.0;
        this.aliquotaFCPSt = 0.0;
        this.valorFCPSt = 0.0;
        this.aliquotaFCPStRetido = 0.0;
        this.valorFCPStRetido = 0.0;
    }

    @Id
    @Column(name="ID_LIVRO_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LIVRO_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_CFOP"))
    public Cfop getCfop() {
        return this.cfop;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_ICMS", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_INCIDENCIA_ICMS"))
    public IncidenciaIcms getIncidenciaIcms() {
        return this.incidenciaIcms;
    }

    public void setIncidenciaIcms(IncidenciaIcms incidenciaIcms) {
        this.incidenciaIcms = incidenciaIcms;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_IPI", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_INCIDENCIA_IPI"))
    public IncidenciaIpi getIncidenciaIpi() {
        return this.incidenciaIpi;
    }

    public void setIncidenciaIpi(IncidenciaIpi incidenciaIpi) {
        this.incidenciaIpi = incidenciaIpi;
    }

    @Column(name="ALIQUOTA_ICMS", precision=15, scale=2)
    public Double getAliquotaIcms() {
        return this.aliquotaIcms;
    }

    public void setAliquotaIcms(Double aliquotaIcms) {
        this.aliquotaIcms = aliquotaIcms;
    }

    @Column(name="ALIQUOTA_ICMS_PRODUTO", precision=15, scale=2)
    public Double getAliqutoaIcmsProduto() {
        return this.aliqutoaIcmsProduto;
    }

    public void setAliqutoaIcmsProduto(Double aliqutoaIcmsProduto) {
        this.aliqutoaIcmsProduto = aliqutoaIcmsProduto;
    }

    @Column(name="VALOR_ICMS_TRIBUTADO", precision=15, scale=2)
    public Double getValorIcmsTributado() {
        return this.valorIcmsTributado;
    }

    public void setValorIcmsTributado(Double valorIcmsTributado) {
        this.valorIcmsTributado = valorIcmsTributado;
    }

    @Column(name="VALOR_ICMS_ISENTO", precision=15, scale=2)
    public Double getValorIcmsIsento() {
        return this.valorIcmsIsento;
    }

    public void setValorIcmsIsento(Double valorIcmsIsento) {
        this.valorIcmsIsento = valorIcmsIsento;
    }

    @Column(name="VALOR_ICMS_OUTROS", precision=15, scale=2)
    public Double getValorIcmsOutros() {
        return this.valorIcmsOutros;
    }

    public void setValorIcmsOutros(Double valorIcmsOutros) {
        this.valorIcmsOutros = valorIcmsOutros;
    }

    @Column(name="VALOR_ICMS", precision=15, scale=2)
    public Double getValorIcms() {
        return this.valorIcms;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
    }

    @Column(name="VALOR_BC_ICMS_ST", precision=15, scale=2)
    public Double getValorBCIcmsSt() {
        return this.valorBCIcmsSt;
    }

    public void setValorBCIcmsSt(Double valorBCIcmsSt) {
        this.valorBCIcmsSt = valorBCIcmsSt;
    }

    @Column(name="VALOR_ICMS_ST", precision=15, scale=2)
    public Double getValorIcmsSt() {
        return this.valorIcmsSt;
    }

    public void setValorIcmsSt(Double valorIcmsSt) {
        this.valorIcmsSt = valorIcmsSt;
    }

    @Column(name="VALOR_IPI_TRIBUTADO", precision=15, scale=2)
    public Double getValorIpiTributado() {
        return this.valorIpiTributado;
    }

    public void setValorIpiTributado(Double valorIpiTributado) {
        this.valorIpiTributado = valorIpiTributado;
    }

    @Column(name="VALOR_IPI_ISENTO", precision=15, scale=2)
    public Double getValorIpiIsento() {
        return this.valorIpiIsento;
    }

    public void setValorIpiIsento(Double valorIpiIsento) {
        this.valorIpiIsento = valorIpiIsento;
    }

    @Column(name="VALOR_IPI_OUTROS", precision=15, scale=2)
    public Double getValorIpiOutros() {
        return this.valorIpiOutros;
    }

    public void setValorIpiOutros(Double valorIpiOutros) {
        this.valorIpiOutros = valorIpiOutros;
    }

    @Column(name="VALOR_IPI_INDUSTRIA", precision=15, scale=2)
    public Double getValorIpiIndustria() {
        return this.valorIpiIndustria;
    }

    public void setValorIpiIndustria(Double valorIpiIndustria) {
        this.valorIpiIndustria = valorIpiIndustria;
    }

    @Column(name="VALOR_INSS", precision=15, scale=2)
    public Double getValorInss() {
        return this.valorInss;
    }

    public void setValorInss(Double valorInss) {
        this.valorInss = valorInss;
    }

    @Column(name="VALOR_IRRF", precision=15, scale=2)
    public Double getValorIrrf() {
        return this.valorIrrf;
    }

    public void setValorIrrf(Double valorIrrf) {
        this.valorIrrf = valorIrrf;
    }

    @Column(name="VALOR_ISS", precision=15, scale=2)
    public Double getValorIss() {
        return this.valorIss;
    }

    public void setValorIss(Double valorIss) {
        this.valorIss = valorIss;
    }

    @Column(name="VALOR_ICMS_SEM_APROV", precision=15, scale=2)
    public Double getValorIcmsSemAprov() {
        return this.valorIcmsSemAprov;
    }

    public void setValorIcmsSemAprov(Double valorIcmsSemAprov) {
        this.valorIcmsSemAprov = valorIcmsSemAprov;
    }

    @Column(name="VALOR_IPI_COMERCIO", precision=15, scale=2)
    public Double getValorIpiComercio() {
        return this.valorIpiComercio;
    }

    public void setValorIpiComercio(Double valorIpiComercio) {
        this.valorIpiComercio = valorIpiComercio;
    }

    @Column(name="VALOR_IPI_OBSERVACAO", precision=15, scale=2)
    public Double getValorIpiObservacao() {
        return this.valorIpiObservacao;
    }

    public void setValorIpiObservacao(Double valorIpiObservacao) {
        this.valorIpiObservacao = valorIpiObservacao;
    }

    @Column(name="VALOR_LEI_10833", precision=15, scale=2)
    public Double getValorLei10833() {
        return this.valorLei10833;
    }

    public void setValorLei10833(Double valorLei10833) {
        this.valorLei10833 = valorLei10833;
    }

    @Column(name="VALOR_OUTROS", precision=15, scale=2)
    public Double getValorOutros() {
        return this.valorOutros;
    }

    public void setValorOutros(Double valorOutros) {
        this.valorOutros = valorOutros;
    }

    @Column(name="VALOR_FUNRURAL", precision=15, scale=2)
    public Double getValorFunrural() {
        return this.valorFunrural;
    }

    public void setValorFunrural(Double valorFunrural) {
        this.valorFunrural = valorFunrural;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIVRO")
    public Date getDataLivro() {
        return this.dataLivro;
    }

    public void setDataLivro(Date dataLivro) {
        this.dataLivro = dataLivro;
    }

    @Column(name="VALOR_DIF_ALIQUOTA", precision=15, scale=2)
    public Double getValorDifAliquota() {
        return this.valorDifAliquota;
    }

    public void setValorDifAliquota(Double difAliquota) {
        this.valorDifAliquota = difAliquota;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa identificadorEmpresa) {
        this.empresa = identificadorEmpresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_UF"))
    public UnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(UnidadeFederativa uf) {
        this.uf = uf;
    }

    @Column(name="ENTRADA_SAIDA_NATUREZA_OP")
    public Short getEntradaSaidaNaturezaOp() {
        return this.entradaSaidaNaturezaOp;
    }

    public void setEntradaSaidaNaturezaOp(Short entradaSaidaNaturezaOp) {
        this.entradaSaidaNaturezaOp = entradaSaidaNaturezaOp;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_ICMS_ST", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_UF_ICMSST"))
    public UnidadeFederativa getUfIcmsSt() {
        return this.ufIcmsSt;
    }

    public void setUfIcmsSt(UnidadeFederativa ufIcmsSt) {
        this.ufIcmsSt = ufIcmsSt;
    }

    @Column(name="CANCELADO")
    public Short getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Short cancelado) {
        this.cancelado = cancelado;
    }

    @Column(name="VALOR_PIS", precision=15, scale=2)
    public Double getValorPis() {
        return this.valorPis;
    }

    public void setValorPis(Double valorPis) {
        this.valorPis = valorPis;
    }

    @Column(name="VALOR_COFINS", precision=15, scale=2)
    public Double getValorCofins() {
        return this.valorCofins;
    }

    public void setValorCofins(Double valorCofins) {
        this.valorCofins = valorCofins;
    }

    @Column(name="VALOR_CONT_SOCIAL", precision=15, scale=2)
    public Double getValorContSocial() {
        return this.valorContSocial;
    }

    public void setValorContSocial(Double valorContSocial) {
        this.valorContSocial = valorContSocial;
    }

    @Column(name="VALOR_SEST_SENAT", precision=15, scale=2)
    public Double getValorSestSenat() {
        return this.valorSestSenat;
    }

    public void setValorSestSenat(Double valorSestSenat) {
        this.valorSestSenat = valorSestSenat;
    }

    @Column(name="VR_NAO_TRIB_ICMS", precision=15, scale=2)
    public Double getVrNaoTribIcms() {
        return this.vrNaoTribIcms;
    }

    public void setVrNaoTribIcms(Double vrNaoTribIcms) {
        this.vrNaoTribIcms = vrNaoTribIcms;
    }

    @OneToMany(mappedBy="livroFiscal")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ObservacaoLivroFiscal> getObsLivroFiscal() {
        return this.obsLivroFiscal;
    }

    public void setObsLivroFiscal(List<ObservacaoLivroFiscal> obsLivroFiscal) {
        this.obsLivroFiscal = obsLivroFiscal;
    }

    @Column(name="VR_FRETE_ICMS_ST", precision=15, scale=2)
    public Double getValorFreteIcmsST() {
        return this.valorFreteIcmsST;
    }

    public void setValorFreteIcmsST(Double valorFreteIcmsST) {
        this.valorFreteIcmsST = valorFreteIcmsST;
    }

    @Column(name="VR_BC_PIS", precision=15, scale=2)
    public Double getVrBCPis() {
        return this.vrBCPis;
    }

    public void setVrBCPis(Double valorBCPis) {
        this.vrBCPis = valorBCPis;
    }

    @Column(name="VR_BC_COFINS", precision=15, scale=2)
    public Double getVrBCCofins() {
        return this.vrBCCofins;
    }

    public void setVrBCCofins(Double valorBCCofins) {
        this.vrBCCofins = valorBCCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_PIS", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_INC_PIS"))
    public IncidenciaPisCofins getIncidenciaPis() {
        return this.incidenciaPis;
    }

    public void setIncidenciaPis(IncidenciaPisCofins incidenciaPis) {
        this.incidenciaPis = incidenciaPis;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_COFINS", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_INC_COFINS"))
    public IncidenciaPisCofins getIncidenciaCofins() {
        return this.incidenciaCofins;
    }

    public void setIncidenciaCofins(IncidenciaPisCofins incidenciaCofins) {
        this.incidenciaCofins = incidenciaCofins;
    }

    @Column(name="ALIQUOTA_COFINS", precision=15, scale=2)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=2)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="ALIQUOTA_PIS_QTDE", precision=15, scale=4)
    public Double getAliquotaPisQtde() {
        return this.aliquotaPisQtde;
    }

    public void setAliquotaPisQtde(Double aliquotaPisQtde) {
        this.aliquotaPisQtde = aliquotaPisQtde;
    }

    @Column(name="ALIQUOTA_COFINS_QTDE", precision=15, scale=4)
    public Double getAliquotaCofinsQtde() {
        return this.aliquotaCofinsQtde;
    }

    public void setAliquotaCofinsQtde(Double aliquotaCofinsQtde) {
        this.aliquotaCofinsQtde = aliquotaCofinsQtde;
    }

    public boolean equals(Object other) {
        boolean aux;
        if (!(other instanceof LivroFiscal)) {
            return false;
        }
        if (this.getCfop() == null || this.getIncidenciaIcms() == null || this.getIncidenciaIpi() == null) {
            return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
        }
        LivroFiscal lv = (LivroFiscal)other;
        boolean bl = aux = this.getCfop().equals(lv.getCfop()) && this.getIncidenciaIcms().equals(lv.getIncidenciaIcms()) && this.getIncidenciaIpi().equals(lv.getIncidenciaIpi()) && this.getAliquotaIcms().doubleValue() == lv.getAliquotaIcms().doubleValue();
        if (this.getPlanoConta() != null && lv.getPlanoConta() != null) {
            boolean bl2 = aux = this.getPlanoConta().equals(lv.getPlanoConta()) && aux;
        }
        if (this.getIncidenciaPis() != null && lv.getIncidenciaPis() != null) {
            boolean bl3 = aux = this.getIncidenciaPis().equals(lv.getIncidenciaPis()) && aux;
        }
        if (this.getIncidenciaCofins() != null && lv.getIncidenciaCofins() != null) {
            boolean bl4 = aux = this.getIncidenciaCofins().equals(lv.getIncidenciaCofins()) && aux;
        }
        if (this.getAliquotaCofins() != null && lv.getAliquotaCofins() != null) {
            boolean bl5 = aux = this.getAliquotaCofins().doubleValue() == lv.getAliquotaCofins().doubleValue() && aux;
        }
        if (this.getAliquotaPis() != null && lv.getAliquotaPis() != null) {
            boolean bl6 = aux = this.getAliquotaPis().doubleValue() == lv.getAliquotaPis().doubleValue() && aux;
        }
        if (this.getAliquotaPisQtde() != null && lv.getAliquotaPisQtde() != null) {
            boolean bl7 = aux = this.getAliquotaPisQtde().doubleValue() == lv.getAliquotaPisQtde().doubleValue() && aux;
        }
        if (this.getAliquotaCofinsQtde() != null && lv.getAliquotaCofinsQtde() != null) {
            aux = this.getAliquotaCofinsQtde().doubleValue() == lv.getAliquotaCofinsQtde().doubleValue() && aux;
        }
        return aux;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VR_CUSTO_ICMSST", precision=15, scale=2)
    public Double getVrCustoICMSST() {
        return this.vrCustoICMSST;
    }

    public void setVrCustoICMSST(Double vrCustoICMSST) {
        this.vrCustoICMSST = vrCustoICMSST;
    }

    @Column(name="VR_BC_CUSTO_ICMSST", precision=15, scale=2)
    public Double getVrBCCustoICMSST() {
        return this.vrBCCustoICMSST;
    }

    public void setVrBCCustoICMSST(Double vrBCCustoICMSST) {
        this.vrBCCustoICMSST = vrBCCustoICMSST;
    }

    @Column(name="VALOR_ICMS_PARTILHA_DEST", precision=15, scale=2)
    public Double getValorIcmsPartilhaDest() {
        return this.valorIcmsPartilhaDest;
    }

    public void setValorIcmsPartilhaDest(Double valorIcmsPartilhaDest) {
        this.valorIcmsPartilhaDest = valorIcmsPartilhaDest;
    }

    @Column(name="VALOR_ICMS_PARTILHA_REM", precision=15, scale=2)
    public Double getValorIcmsPartilhaRem() {
        return this.valorIcmsPartilhaRem;
    }

    public void setValorIcmsPartilhaRem(Double valorIcmsPartilhaRem) {
        this.valorIcmsPartilhaRem = valorIcmsPartilhaRem;
    }

    @Column(name="VALOR_FUNDO_POBREZA", precision=15, scale=2)
    public Double getValorFundoPobreza() {
        return this.valorFundoPobreza;
    }

    public void setValorFundoPobreza(Double valorFundoPobreza) {
        this.valorFundoPobreza = valorFundoPobreza;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE", foreignKey=@ForeignKey(name="FK_LIVRO_FISCAL_CIDADE"))
    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Column(name="VALOR_ICMS_DESONERADO", precision=15, scale=2)
    public Double getValorIcmsDesonerado() {
        return this.valorIcmsDesonerado;
    }

    public void setValorIcmsDesonerado(Double valorIcmsDesonerado) {
        this.valorIcmsDesonerado = valorIcmsDesonerado;
    }

    @Column(nullable=false, name="ALIQUOTA_FCP", precision=15, scale=6)
    public Double getAliquotaFCP() {
        return this.aliquotaFCP;
    }

    public void setAliquotaFCP(Double aliquotaFCP) {
        this.aliquotaFCP = aliquotaFCP;
    }

    @Column(nullable=false, name="VALOR_FCP", precision=15, scale=2)
    public Double getValorFCP() {
        return this.valorFCP;
    }

    public void setValorFCP(Double valorFCP) {
        this.valorFCP = valorFCP;
    }

    @Column(nullable=false, name="ALIQUOTA_FCP_ST", precision=15, scale=6)
    public Double getAliquotaFCPSt() {
        return this.aliquotaFCPSt;
    }

    public void setAliquotaFCPSt(Double aliquotaFCPSt) {
        this.aliquotaFCPSt = aliquotaFCPSt;
    }

    @Column(nullable=false, name="VALOR_FCP_ST", precision=15, scale=2)
    public Double getValorFCPSt() {
        return this.valorFCPSt;
    }

    public void setValorFCPSt(Double valorFCPSt) {
        this.valorFCPSt = valorFCPSt;
    }

    @Column(nullable=false, name="ALIQUOTA_FCP_ST_RETIDO", precision=15, scale=6)
    public Double getAliquotaFCPStRetido() {
        return this.aliquotaFCPStRetido;
    }

    public void setAliquotaFCPStRetido(Double aliquotaFCPStRetido) {
        this.aliquotaFCPStRetido = aliquotaFCPStRetido;
    }

    @Column(nullable=false, name="VALOR_FCP_ST_RETIDO", precision=15, scale=2)
    public Double getValorFCPStRetido() {
        return this.valorFCPStRetido;
    }

    public void setValorFCPStRetido(Double valorFCPStRetido) {
        this.valorFCPStRetido = valorFCPStRetido;
    }

    @Column(name="VALOR_IPI_DEVOL", precision=15, scale=2)
    public Double getValorIpiDevolucao() {
        return this.valorIpiDevolucao;
    }

    public void setValorIpiDevolucao(Double valorIpiDevolucao) {
        this.valorIpiDevolucao = valorIpiDevolucao;
    }

    @Column(name="VALOR_ICMS_DIFERIMENTO", precision=15, scale=2)
    public Double getValorIcmsDiferimento() {
        return this.valorIcmsDiferimento;
    }

    public void setValorIcmsDiferimento(Double valorIcmsDiferimento) {
        this.valorIcmsDiferimento = valorIcmsDiferimento;
    }

    @Column(name="descartar_Dapi")
    public Short getDescartarDapi() {
        return this.descartarDapi;
    }

    public void setDescartarDapi(Short descartarDapi) {
        this.descartarDapi = descartarDapi;
    }
}

