/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedoraTicketAlimentacao;
import com.touchcomp.basementor.model.vo.LocalTrabalhoColaboradorCidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOCAL_TRABALHO_COLABORADOR")
public class LocalTrabalhoColaborador
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Double valorVale = 0.0;
    private Double valorCestaBasica = 0.0;
    private Double percDescontoVA = 0.0;
    private Double valorDescontoVA = 0.0;
    private Short tipoDescontoVA = 0;
    private Double diasApuracaoVale = 0.0;
    private Short recebeCestaFixa = 0;
    private Short tipoTicket = 0;
    private Short personalizarValoresBeneficios = 0;
    private FornecedoraTicketAlimentacao fornecedorTicket;
    private Pessoa pessoa;
    private Short efetuaPagamentoCestaFerias = 0;
    private Short naoEfetuaPagamentoCestaFaltas = 0;
    private Double valorTotalFixo = 0.0;
    private Double valorDescontoFixo = 0.0;
    private Double limiteFaltas = 0.0;
    private Short grupoBeneficio = 1;
    private List<LocalTrabalhoColaboradorCidade> cidades = new ArrayList<LocalTrabalhoColaboradorCidade>();
    private Short abonarAtestadoHora = 0;
    private Double limiteAtestadoHora = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_LOCAL_TRABALHO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOCAL_TRABALHO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DTA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOCAL_TRABALHO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="VALOR_VALE", precision=15, scale=2)
    public Double getValorVale() {
        return this.valorVale;
    }

    public void setValorVale(Double valorVale) {
        this.valorVale = valorVale;
    }

    @Column(name="VALOR_CESTA_BASICA", precision=15, scale=2)
    public Double getValorCestaBasica() {
        return this.valorCestaBasica;
    }

    public void setValorCestaBasica(Double valorCestaBasica) {
        this.valorCestaBasica = valorCestaBasica;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao().toUpperCase()}) : "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="RECEBE_CESTA_FIXA")
    public Short getRecebeCestaFixa() {
        return this.recebeCestaFixa;
    }

    public void setRecebeCestaFixa(Short recebeCestaFixa) {
        this.recebeCestaFixa = recebeCestaFixa;
    }

    @Column(name="TIPO_TICKET")
    public Short getTipoTicket() {
        return this.tipoTicket;
    }

    public void setTipoTicket(Short tipoTicket) {
        this.tipoTicket = tipoTicket;
    }

    @Column(name="PERSONALIZAR_VALORES_BENEFICIOS")
    public Short getPersonalizarValoresBeneficios() {
        return this.personalizarValoresBeneficios;
    }

    public void setPersonalizarValoresBeneficios(Short personalizarValoresBeneficios) {
        this.personalizarValoresBeneficios = personalizarValoresBeneficios;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR_TICKET", foreignKey=@ForeignKey(name="FK_LOCAL_TRABALHO_FORNEC_TICKET"))
    public FornecedoraTicketAlimentacao getFornecedorTicket() {
        return this.fornecedorTicket;
    }

    public void setFornecedorTicket(FornecedoraTicketAlimentacao fornecedorTicket) {
        this.fornecedorTicket = fornecedorTicket;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_LOCAL_TRABALHO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="EFETUA_PAGAMENTO_CESTA_FERIAS")
    public Short getEfetuaPagamentoCestaFerias() {
        return this.efetuaPagamentoCestaFerias;
    }

    public void setEfetuaPagamentoCestaFerias(Short efetuaPagamentoCestaFerias) {
        this.efetuaPagamentoCestaFerias = efetuaPagamentoCestaFerias;
    }

    @Column(name="NAO_EFETUA_PAG_CESTA_FALTAS")
    public Short getNaoEfetuaPagamentoCestaFaltas() {
        return this.naoEfetuaPagamentoCestaFaltas;
    }

    public void setNaoEfetuaPagamentoCestaFaltas(Short naoEfetuaPagamentoCestaFaltas) {
        this.naoEfetuaPagamentoCestaFaltas = naoEfetuaPagamentoCestaFaltas;
    }

    @Column(name="PERC_DESCONTO_VA", precision=15, scale=4)
    public Double getPercDescontoVA() {
        return this.percDescontoVA;
    }

    public void setPercDescontoVA(Double percDescontoVA) {
        this.percDescontoVA = percDescontoVA;
    }

    @Column(name="VALOR_DESCONTO_VA", precision=15, scale=4)
    public Double getValorDescontoVA() {
        return this.valorDescontoVA;
    }

    public void setValorDescontoVA(Double valorDescontoVA) {
        this.valorDescontoVA = valorDescontoVA;
    }

    @Column(name="TIPO_DESCONTO_VA")
    public Short getTipoDescontoVA() {
        return this.tipoDescontoVA;
    }

    public void setTipoDescontoVA(Short tipoDescontoVA) {
        this.tipoDescontoVA = tipoDescontoVA;
    }

    @Column(name="DIAS_APURACAO_VALE", precision=15, scale=4)
    public Double getDiasApuracaoVale() {
        return this.diasApuracaoVale;
    }

    public void setDiasApuracaoVale(Double diasApuracaoVale) {
        this.diasApuracaoVale = diasApuracaoVale;
    }

    @Column(name="VALOR_TOTAL_FIXO", precision=15, scale=2)
    public Double getValorTotalFixo() {
        return this.valorTotalFixo;
    }

    public void setValorTotalFixo(Double valorTotalFixo) {
        this.valorTotalFixo = valorTotalFixo;
    }

    @Column(name="VALOR_DESCONTO_FIXO", precision=15, scale=4)
    public Double getValorDescontoFixo() {
        return this.valorDescontoFixo;
    }

    public void setValorDescontoFixo(Double valorDescontoFixo) {
        this.valorDescontoFixo = valorDescontoFixo;
    }

    @Column(name="LIMITE_FALTAS", precision=15, scale=4)
    public Double getLimiteFaltas() {
        return this.limiteFaltas;
    }

    public void setLimiteFaltas(Double limiteFaltas) {
        this.limiteFaltas = limiteFaltas;
    }

    @Column(name="GRUPO_BENEFICIO")
    public Short getGrupoBeneficio() {
        return this.grupoBeneficio;
    }

    public void setGrupoBeneficio(Short grupoBeneficio) {
        this.grupoBeneficio = grupoBeneficio;
    }

    @OneToMany(mappedBy="localTrabalhoColaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LocalTrabalhoColaboradorCidade> getCidades() {
        return this.cidades;
    }

    public void setCidades(List<LocalTrabalhoColaboradorCidade> cidades) {
        this.cidades = cidades;
    }

    @Column(name="ABONAR_ATESTADO_HORAS")
    public Short getAbonarAtestadoHora() {
        return this.abonarAtestadoHora;
    }

    public void setAbonarAtestadoHora(Short abonarAtestadoHora) {
        this.abonarAtestadoHora = abonarAtestadoHora;
    }

    @Column(name="LIMITE_ATESTADO_HORA", precision=15, scale=2)
    public Double getLimiteAtestadoHora() {
        return this.limiteAtestadoHora;
    }

    public void setLimiteAtestadoHora(Double limiteAtestadoHora) {
        this.limiteAtestadoHora = limiteAtestadoHora;
    }
}

