/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoLocalizacoesRelLoc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="LOCALIZACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_LOCALIZACAO_NOME", columnNames={"NOME"})})
public class Localizacao
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<GrupoLocalizacoesRelLoc> grupoLocalizacoesRel;
    private Short ativo;

    public Localizacao() {
        this.grupoLocalizacoesRel = new ArrayList<GrupoLocalizacoesRelLoc>();
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    public Localizacao(Long id, String n) {
        this.identificador = id;
        this.nome = n;
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_LOCALIZACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOCALIZACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOCALIZACAO_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setIdentificador(Long idLocalizacao) {
        this.identificador = idLocalizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="localizacao")
    public List<GrupoLocalizacoesRelLoc> getGrupoLocalizacoesRel() {
        return this.grupoLocalizacoesRel;
    }

    public void setGrupoLocalizacoesRel(List<GrupoLocalizacoesRelLoc> grupoLocalizacoesRel) {
        this.grupoLocalizacoesRel = grupoLocalizacoesRel;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

