/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="LOG_COLETA")
public class LogColeta
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Date dataHoraColeta;
    private Integer valorColeta = 0;
    private Integer valorAcumulado = 0;
    private String coleta;
    private String coletaAnterior;
    private String coletaPosterior;
    private String tipoPontoControle;
    private String ativo;
    private Long ativoIdentificador = 0L;

    @Id
    @Column(nullable=false, name="ID_LOG_COLETA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_COLETA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOG_COLETA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="COLETA")
    public String getColeta() {
        return this.coleta;
    }

    public void setColeta(String coleta) {
        this.coleta = coleta;
    }

    @Column(name="COLETA_ANTERIOR")
    public String getColetaAnterior() {
        return this.coletaAnterior;
    }

    public void setColetaAnterior(String coletaAnterior) {
        this.coletaAnterior = coletaAnterior;
    }

    @Column(name="COLETA_POSTERIOR")
    public String getColetaPosterior() {
        return this.coletaPosterior;
    }

    public void setColetaPosterior(String coletaPosterior) {
        this.coletaPosterior = coletaPosterior;
    }

    @Column(name="VALOR_COLETA", precision=15, scale=0)
    public Integer getValorColeta() {
        return this.valorColeta;
    }

    public void setValorColeta(Integer valorColeta) {
        this.valorColeta = valorColeta;
    }

    @Column(name="VALOR_ACUMULADO", precision=15, scale=0)
    public Integer getValorAcumulado() {
        return this.valorAcumulado;
    }

    public void setValorAcumulado(Integer valorAcumulado) {
        this.valorAcumulado = valorAcumulado;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_HORA_COLETA")
    public Date getDataHoraColeta() {
        return this.dataHoraColeta;
    }

    public void setDataHoraColeta(Date dataHoraColeta) {
        this.dataHoraColeta = dataHoraColeta;
    }

    @Column(name="TIPO_PONTO_CONTROLE", length=100)
    public String getTipoPontoControle() {
        return this.tipoPontoControle;
    }

    public void setTipoPontoControle(String tipoPontoControle) {
        this.tipoPontoControle = tipoPontoControle;
    }

    @Column(name="ATIVO", length=100)
    public String getAtivo() {
        return this.ativo;
    }

    @Column(name="ATIVO_IDENTIFICADOR", length=100)
    public Long getAtivoIdentificador() {
        return this.ativoIdentificador;
    }

    public void setAtivoIdentificador(Long ativoIdentificador) {
        this.ativoIdentificador = ativoIdentificador;
    }

    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColeta()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

