/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="LOG_CONEXAO_USUARIO")
public class LogConexaoUsuario
implements InterfaceVO {
    private Long identificador;
    private Date dataLogin;
    private Date dataLogout;
    private Usuario usuario;
    private Grupo grupoUsuarios;
    private Empresa empresa;
    private GrupoEmpresa grupoEmpresa;
    private Double horasConectado = 0.0;
    private Short logoutTimeout = 0;

    @Id
    @Column(name="ID_LOG_CONEXAO_USUARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_CONEXAO_USUARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long idConexao) {
        this.identificador = idConexao;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOG_USUARIOS_CONECTADOS_USER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_LOGIN")
    public Date getDataLogin() {
        return this.dataLogin;
    }

    public void setDataLogin(Date dataLogin) {
        this.dataLogin = dataLogin;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_LOGOUT")
    public Date getDataLogout() {
        return this.dataLogout;
    }

    public void setDataLogout(Date dataLoggout) {
        this.dataLogout = dataLoggout;
    }

    @Column(nullable=false, name="HORAS_CONECTADO", precision=15, scale=2)
    public Double getHorasConectado() {
        return this.horasConectado;
    }

    public void setHorasConectado(Double horasConectados) {
        this.horasConectado = horasConectados;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOG_USUARIOS_CONECTADOS_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_USUARIOS")
    public Grupo getGrupoUsuarios() {
        return this.grupoUsuarios;
    }

    public void setGrupoUsuarios(Grupo grupoUsuarios) {
        this.grupoUsuarios = grupoUsuarios;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA")
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Column(name="logout_timeout")
    public Short getLogoutTimeout() {
        return this.logoutTimeout;
    }

    public void setLogoutTimeout(Short logoutTimeout) {
        this.logoutTimeout = logoutTimeout;
    }
}

