/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SituacaoCte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="LOG_CTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_LOG_CTE", columnNames={"DATA_EVENTO"})})
public class LogCte
implements InterfaceVO {
    private Long identificador;
    private SituacaoCte situacaoCte;
    private Cte cte;
    private Timestamp dataEvento;
    private Pessoa pessoaResp;
    private String descricaoComp;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;

    @Id
    @Column(name="ID_LOG_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_SITUACAO_CTE", foreignKey=@ForeignKey(name="FK_LOG_CTE_SIT_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SituacaoCte getSituacaoCte() {
        return this.situacaoCte;
    }

    public void setSituacaoCte(SituacaoCte situacaoCte) {
        this.situacaoCte = situacaoCte;
    }

    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_LOG_CTE_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @Column(name="DATA_EVENTO")
    public Timestamp getDataEvento() {
        return this.dataEvento;
    }

    public void setDataEvento(Timestamp dataEvento) {
        this.dataEvento = dataEvento;
    }

    @JoinColumn(name="ID_PESSOA_RESP", foreignKey=@ForeignKey(name="FK_LOG_CTE_PES_RESP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaResp() {
        return this.pessoaResp;
    }

    public void setPessoaResp(Pessoa pessoaResp) {
        this.pessoaResp = pessoaResp;
    }

    @Column(name="DESCRICAO_COMPLEMENTAR", length=500)
    public String getDescricaoComp() {
        return this.descricaoComp;
    }

    public void setDescricaoComp(String descricaoComp) {
        this.descricaoComp = descricaoComp;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOG_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

