/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoLogTitulos;
import com.touchcomp.basementor.model.vo.ItemLogDadosTitulo;
import com.touchcomp.basementor.model.vo.TipoAlteracaoTitulo;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOG_TITULOS")
public class LogTitulos
implements InterfaceVO {
    private Long identificador;
    private Titulo titulo;
    private Date dataCadastro;
    private Empresa empresa;
    private Usuario usuario;
    private String motivo;
    private ItemLogDadosTitulo itemLogDadosTitulo;
    private TipoAlteracaoTitulo tipoAlteracaoTitulo;
    private BoletoTitulo boletoTitulo;
    private GrupoLogTitulos grupoLogTitulos;

    @Id
    @Column(nullable=false, name="ID_LOG_TITULOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_TITULOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_LOG_TITULOS_TITULO"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOG_TITULOS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(nullable=false, name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOG_TITULOS_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(nullable=false, name="MOTIVO_ALTERACAO", length=500)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @OneToOne(mappedBy="logTitulos", fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ItemLogDadosTitulo getItemLogDadosTitulo() {
        return this.itemLogDadosTitulo;
    }

    public void setItemLogDadosTitulo(ItemLogDadosTitulo itemLogDadosTitulo) {
        this.itemLogDadosTitulo = itemLogDadosTitulo;
    }

    @JoinColumn(name="ID_TIPO_ALTERACAO_TITULO", foreignKey=@ForeignKey(name="FK_LOG_TITULOS_TIPO_ALTER_TITUL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoAlteracaoTitulo getTipoAlteracaoTitulo() {
        return this.tipoAlteracaoTitulo;
    }

    public void setTipoAlteracaoTitulo(TipoAlteracaoTitulo tipoAlteracaoTitulo) {
        this.tipoAlteracaoTitulo = tipoAlteracaoTitulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BOLETO_TITULO", foreignKey=@ForeignKey(name="FK_LOG_TITULOS_BOL_TIT"))
    public BoletoTitulo getBoletoTitulo() {
        return this.boletoTitulo;
    }

    public void setBoletoTitulo(BoletoTitulo boletoTitulo) {
        this.boletoTitulo = boletoTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_LOG_TITULOS", foreignKey=@ForeignKey(name="FK_LOG_TIT_GR_LOG_TIT"))
    public GrupoLogTitulos getGrupoLogTitulos() {
        return this.grupoLogTitulos;
    }

    public void setGrupoLogTitulos(GrupoLogTitulos grupoLogTitulos) {
        this.grupoLogTitulos = grupoLogTitulos;
    }
}

