/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="LOTE_CONTABIL", uniqueConstraints={@UniqueConstraint(name="UNQ1_LOTE_CONTABIL", columnNames={"NUMERO_LOTE"})})
public class LoteContabil
implements InterfaceVO {
    private Long identificador;
    private Long numeroLote;
    private GrupoEmpresa grupoEmpresa;
    private Usuario usuario;
    private Date dataLote;
    private Integer indicador = 0;
    private Date dataCadastro;
    private List<Lancamento> lancamentos = new LinkedList<Lancamento>();
    private Double totalCreditos = 0.0;
    private Double totalDebitos = 0.0;
    private Double saldo = 0.0;
    private String origem;

    @Id
    @Column(name="ID_LOTE_CONTABIL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_CONTABIL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="NUMERO_LOTE")
    @Generated(value=GenerationTime.ALWAYS)
    @Ignore
    public Long getNumeroLote() {
        return this.numeroLote;
    }

    public void setNumeroLote(Long numeroLote) {
        this.numeroLote = numeroLote;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOTE_CONTABIL_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="DATA_LOTE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLote() {
        return this.dataLote;
    }

    public void setDataLote(Date data) {
        this.dataLote = data;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Nr Lote: {0}", (Object[])new Object[]{this.getNumeroLote() != null ? this.getNumeroLote().toString() : "NA"});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INDICADOR")
    public Integer getIndicador() {
        return this.indicador;
    }

    public void setIndicador(Integer indicador) {
        this.indicador = indicador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(mappedBy="loteContabil", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.REMOVE, CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Lancamento> getLancamentos() {
        return this.lancamentos;
    }

    public void setLancamentos(List<Lancamento> lancamentos) {
        this.lancamentos = lancamentos;
    }

    @Column(updatable=false, name="TOTAL_CREDITOS", precision=15, scale=2)
    @Generated(value=GenerationTime.ALWAYS)
    public Double getTotalCreditos() {
        return this.totalCreditos;
    }

    public void setTotalCreditos(Double totalCreditos) {
        this.totalCreditos = totalCreditos;
    }

    @Column(updatable=false, name="TOTAL_DEBITOS", precision=15, scale=2)
    @Generated(value=GenerationTime.ALWAYS)
    public Double getTotalDebitos() {
        return this.totalDebitos;
    }

    public void setTotalDebitos(Double totalDebitos) {
        this.totalDebitos = totalDebitos;
    }

    @Column(updatable=false, nullable=false, name="SALDO", precision=15, scale=2)
    @Generated(value=GenerationTime.ALWAYS)
    public Double getSaldo() {
        return this.saldo;
    }

    public void setSaldo(Double saldo) {
        this.saldo = saldo;
    }

    @Column(name="ORIGEM")
    public String getOrigem() {
        return this.origem;
    }

    public void setOrigem(String origem) {
        this.origem = origem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_CONTABIL_GR_EMPRESA"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }
}

