/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeUrl;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoCTe;
import com.touchcomp.basementor.model.vo.TipoEmissaoCTe;
import com.touchcomp.basementor.model.vo.VersaoCTe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="LOTE_EVENTOS_CTE")
public class LoteEventosCTe
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Short status = 0;
    private String motivoRetorno;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<EventoCTe> eventosCTe = new ArrayList<EventoCTe>();
    private VersaoCTe versaoCTe;
    private TipoEmissaoCTe tipoEmissaoCTe;
    private Short tipoLote = 0;
    private Short tipoUrl = EnumConstCTeUrl.TIPO_URL_PADRAO.getValue();

    @Id
    @Column(name="ID_LOTE_EVENTOS_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_EVENTOS_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="MOTIVO_RETORNO", length=1000)
    public String getMotivoRetorno() {
        return this.motivoRetorno;
    }

    public void setMotivoRetorno(String motivoRetorno) {
        this.motivoRetorno = motivoRetorno;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="loteEventosCTe", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SELECT)
    public List<EventoCTe> getEventosCTe() {
        return this.eventosCTe;
    }

    public void setEventosCTe(List<EventoCTe> eventosCTe) {
        this.eventosCTe = eventosCTe;
    }

    @JoinColumn(name="ID_VERSAO_CTE", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_CTE_VERSAO_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public VersaoCTe getVersaoCTe() {
        return this.versaoCTe;
    }

    public void setVersaoCTe(VersaoCTe versaoCTe) {
        this.versaoCTe = versaoCTe;
    }

    @JoinColumn(name="ID_TIPO_EMISSAO_CTE", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_CTE_TIPO_EM_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEmissaoCTe getTipoEmissaoCTe() {
        return this.tipoEmissaoCTe;
    }

    public void setTipoEmissaoCTe(TipoEmissaoCTe tipoEmissaoCTe) {
        this.tipoEmissaoCTe = tipoEmissaoCTe;
    }

    @Column(name="TIPO_LOTE")
    public Short getTipoLote() {
        return this.tipoLote;
    }

    public void setTipoLote(Short tipoLote) {
        this.tipoLote = tipoLote;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_URL")
    public Short getTipoUrl() {
        return this.tipoUrl;
    }

    public void setTipoUrl(Short tipoUrl) {
        this.tipoUrl = tipoUrl;
    }
}

