/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfiGerarLoteAutoProd;
import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.StatusLoteFabricacao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOTE_FABRICACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_LOTE_FABRICACAO", columnNames={"ID_PRODUTO", "LOTE_FABRICACAO"})})
public class LoteFabricacao
implements InterfaceVO {
    private Long identificador;
    private String loteFabricacao;
    private Date dataFabricacao;
    private Date dataValidade;
    private Produto produto;
    private Short unico = 0;
    private Short naoGerarLoteAutomatico = 0;
    private Timestamp dataAtualizacao;
    private ConfiGerarLoteAutoProd confiGerarLoteAuto;
    private List<FichaTecnicaLoteFabricacao> fichaTecnica = new ArrayList<FichaTecnicaLoteFabricacao>();
    private Short loteBloqueado = 0;
    private Usuario usuario;
    private Date dataLiberacao = new Date();
    private String codigoAgregacao;
    private StatusLoteFabricacao statusLoteFabricacao;

    @Id
    @Column(name="ID_LOTE_FABRICACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_FABRICACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="LOTE_FABRICACAO", length=50)
    public String getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(String loteFabricacao) {
        this.loteFabricacao = loteFabricacao = loteFabricacao != null ? loteFabricacao.toUpperCase().trim() : null;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VALIDADE")
    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Column(name="DATA_FABRICACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFabricacao() {
        return this.dataFabricacao;
    }

    public void setDataFabricacao(Date dataFabricacao) {
        this.dataFabricacao = dataFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_LOTE_FABRICACAO_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="UNICO")
    public Short getUnico() {
        return this.unico;
    }

    public void setUnico(Short unico) {
        this.unico = unico;
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NAO_GERAR_LOTE_AUTOMATICO")
    public Short getNaoGerarLoteAutomatico() {
        return this.naoGerarLoteAutomatico;
    }

    public void setNaoGerarLoteAutomatico(Short naoGerarLoteAutomatico) {
        this.naoGerarLoteAutomatico = naoGerarLoteAutomatico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, insertable=false, name="ID_CONFIG_GERAR_LOTE_AUTO", foreignKey=@ForeignKey(name="FK_LOTE_FABRICACAO_CONF_LOTE"))
    public ConfiGerarLoteAutoProd getConfiGerarLoteAuto() {
        return this.confiGerarLoteAuto;
    }

    public void setConfiGerarLoteAuto(ConfiGerarLoteAutoProd confiGerarLoteAuto) {
        this.confiGerarLoteAuto = confiGerarLoteAuto;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="loteFabricacao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FichaTecnicaLoteFabricacao> getFichaTecnica() {
        return this.fichaTecnica;
    }

    public void setFichaTecnica(List<FichaTecnicaLoteFabricacao> fichaTecnica) {
        this.fichaTecnica = fichaTecnica;
    }

    @Column(name="LOTE_BLOQUEADO")
    public Short getLoteBloqueado() {
        return this.loteBloqueado;
    }

    public void setLoteBloqueado(Short loteBloqueado) {
        this.loteBloqueado = loteBloqueado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOTE_FABRICACAO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="DATA_LIBERACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiberacao() {
        return this.dataLiberacao;
    }

    public void setDataLiberacao(Date dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    @Column(nullable=true, name="COD_AGREGACAO", length=20)
    public String getCodigoAgregacao() {
        return this.codigoAgregacao;
    }

    public void setCodigoAgregacao(String codigoAgregacao) {
        this.codigoAgregacao = codigoAgregacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_LOTE_FABRI_STATUS_LOTE_FABRI"))
    public StatusLoteFabricacao getStatusLoteFabricacao() {
        return this.statusLoteFabricacao;
    }

    public void setStatusLoteFabricacao(StatusLoteFabricacao statusLoteFabricacao) {
        this.statusLoteFabricacao = statusLoteFabricacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getLoteFabricacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

