/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOTE_FATURAMENTO_NFE")
public class LoteFaturamentoNFe
implements InterfaceVO {
    private Long identificador;
    private Date dataEmissao;
    private String numeroReciboLote;
    private List<NotaFiscalPropria> notasFiscais = new ArrayList<NotaFiscalPropria>();
    private Short enviadoReceita = 0;
    private Short statusLote = 0;
    private String motivo;
    private Timestamp dataAtualizacao;
    private Date dataEnvio;
    private PeriodoEmissaoNFe periodoEmissaoNfe;
    private VersaoNFe versaoNFe;
    private Empresa empresa;

    @Id
    @Column(name="ID_LOTE_FATURAMENTO_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_FATURAMENTO_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEntradaSaida) {
        this.dataEmissao = dataEntradaSaida;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="loteFaturamentoNFe", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<NotaFiscalPropria> getNotasFiscais() {
        return this.notasFiscais;
    }

    public void setNotasFiscais(List<NotaFiscalPropria> notas) {
        this.notasFiscais = notas;
    }

    @Column(name="NUMERO_RECIBO_LOTE", length=15)
    public String getNumeroReciboLote() {
        return this.numeroReciboLote;
    }

    public void setNumeroReciboLote(String numeroReciboLote) {
        this.numeroReciboLote = numeroReciboLote;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="STATUS_LOTE")
    public Short getStatusLote() {
        return this.statusLote;
    }

    public void setStatusLote(Short statusLote) {
        this.statusLote = statusLote;
    }

    @Column(name="DATA_ENVIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    @Column(name="MOTIVO", length=1000)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Column(name="ENVIADO_RECEITA")
    public Short getEnviadoReceita() {
        return this.enviadoReceita;
    }

    public void setEnviadoReceita(Short enviadoReceita) {
        this.enviadoReceita = enviadoReceita;
    }

    @Transient
    public int getCodigoEmissao() {
        if (this.getNotasFiscais() != null && !this.getNotasFiscais().isEmpty()) {
            return this.getNotasFiscais().get(0).getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo().shortValue();
        }
        return 1;
    }

    @JoinColumn(name="ID_PERIODO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_NFE_PER_NFE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PeriodoEmissaoNFe getPeriodoEmissaoNfe() {
        return this.periodoEmissaoNfe;
    }

    public void setPeriodoEmissaoNfe(PeriodoEmissaoNFe periodoEmissaoNfe) {
        this.periodoEmissaoNfe = periodoEmissaoNfe;
    }

    @JoinColumn(name="ID_VERSAO_NFE", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_NFE_VER_NFE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public VersaoNFe getVersaoNFe() {
        return this.versaoNFe;
    }

    public void setVersaoNFe(VersaoNFe versaoNFe) {
        this.versaoNFe = versaoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_NFE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Lote Faturamento: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

