/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoWebServNFSe;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOTE_RPS")
public class LoteRps
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Short quantidade = 0;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private List<Rps> rps = new ArrayList<Rps>();
    private Date dataEmissao;
    private String protocoloEnvio;
    private EnderecoWebServNFSe enderecoWebNFse;

    @Id
    @Column(name="ID_LOTE_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_RPS_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="QUANTIDADE")
    public Short getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Short quantidade) {
        this.quantidade = quantidade;
    }

    @OneToMany(mappedBy="loteRps", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<Rps> getRps() {
        return this.rps;
    }

    public void setRps(List<Rps> rps) {
        this.rps = rps;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="PROTOCOLO_ENVIO", length=50)
    public String getProtocoloEnvio() {
        return this.protocoloEnvio;
    }

    public void setProtocoloEnvio(String protocoloEnvio) {
        this.protocoloEnvio = protocoloEnvio;
    }

    @JoinColumn(name="ID_ENDERECO_WEB_NFSE", foreignKey=@ForeignKey(name="FK_LOTE_RPS_ENDERECO_WEB_NFSE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public EnderecoWebServNFSe getEnderecoWebNFse() {
        return this.enderecoWebNFse;
    }

    public void setEnderecoWebNFse(EnderecoWebServNFSe enderecoWebNFse) {
        this.enderecoWebNFse = enderecoWebNFse;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

