/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="MANIFESTO_CTE")
public class ManifestoCte
implements InterfaceVO {
    private Long identificador;
    private Timestamp dataPrevisaoSaida;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private ConjuntoTransportador conjuntoTransportador;
    private Double valorTotalFrete = 0.0;
    private Double valorTotalNotas = 0.0;
    private Empresa empresa;
    private List<Cte> cte = new ArrayList<Cte>();

    @Id
    @Column(name="ID_MANIFESTO_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MANIFESTO_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_PREVISAO_SAIDA")
    public Timestamp getDataPrevisaoSaida() {
        return this.dataPrevisaoSaida;
    }

    public void setDataPrevisaoSaida(Timestamp dataPrevisaoSaida) {
        this.dataPrevisaoSaida = dataPrevisaoSaida;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_MANIFESTO_CTE_CONJ_TRANSP"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @Column(nullable=false, name="VALOR_TOTAL_FRETE", precision=15, scale=2)
    public Double getValorTotalFrete() {
        return this.valorTotalFrete;
    }

    public void setValorTotalFrete(Double valorTotalFrete) {
        this.valorTotalFrete = valorTotalFrete;
    }

    @Column(nullable=false, name="VALOR_TOTAL_NOTAS", precision=15, scale=2)
    public Double getValorTotalNotas() {
        return this.valorTotalNotas;
    }

    public void setValorTotalNotas(Double valorTotalNotas) {
        this.valorTotalNotas = valorTotalNotas;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MANIFESTO_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(targetEntity=Cte.class, cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="MANIFESTO_CTE_CTE", joinColumns={@JoinColumn(name="ID_MANIFESTO_CTE")}, inverseJoinColumns={@JoinColumn(name="ID_CTE")}, uniqueConstraints={@UniqueConstraint(name="UNQ1_MANIFESTO_CTE_CTE", columnNames={"ID_CTE", "ID_MANIFESTO_CTE"})})
    public List<Cte> getCte() {
        return this.cte;
    }

    public void setCte(List<Cte> cte) {
        this.cte = cte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

