/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AverbacaoCte;
import com.touchcomp.basementor.model.vo.CIOTMDFe;
import com.touchcomp.basementor.model.vo.CategoriaCombinacaoVeic;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ErroAverbacaoCte;
import com.touchcomp.basementor.model.vo.ItemCteManualManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.ItemNfeManualManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.LoteFaturamentoManifestoCte;
import com.touchcomp.basementor.model.vo.MDFeAutDownloadXML;
import com.touchcomp.basementor.model.vo.ManifestoCteContratante;
import com.touchcomp.basementor.model.vo.ManifestoCteCte;
import com.touchcomp.basementor.model.vo.ManifestoCteInformacoesPagamentoFrete;
import com.touchcomp.basementor.model.vo.ManifestoCteLacre;
import com.touchcomp.basementor.model.vo.ManifestoCteNfe;
import com.touchcomp.basementor.model.vo.ManifestoCteNfe1A;
import com.touchcomp.basementor.model.vo.ManifestoCteSeguro;
import com.touchcomp.basementor.model.vo.ManifestoCteVeiculo;
import com.touchcomp.basementor.model.vo.MdfAquaviario;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoManifestoCte;
import com.touchcomp.basementor.model.vo.ObservacaoEstNota;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoManifestoCte;
import com.touchcomp.basementor.model.vo.ProdutoPredominanteCte;
import com.touchcomp.basementor.model.vo.RecargaCartaoValePed;
import com.touchcomp.basementor.model.vo.TipoCarga;
import com.touchcomp.basementor.model.vo.TipoModal;
import com.touchcomp.basementor.model.vo.TipoTransportadorMDFe;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VersaoManifestoCte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="MAN_CTE_ELETRONICO")
public class ManifestoCteEletronico
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String cnpj;
    private Short codUF = 0;
    private NaturezaOperacaoManifestoCte naturezaOperacaoManifestoCte;
    private ModeloDocFiscal modeloDocFiscal;
    private String serie;
    private Long numero;
    private Date dataEmissao;
    private Date horaSaida;
    private Integer codChaveAcesso = 0;
    private Integer digitoVerificador = 0;
    private String chaveManifestoCte;
    private ConjuntoTransportador conjuntoTransportador;
    private List<RecargaCartaoValePed> valePedagio = new ArrayList<RecargaCartaoValePed>();
    private List<ManifestoCteLacre> manifestoCteLacre = new ArrayList<ManifestoCteLacre>();
    private List<ManifestoCteCte> cte = new ArrayList<ManifestoCteCte>();
    private List<ItemCteManualManifestoCteEletronico> cteManual = new ArrayList<ItemCteManualManifestoCteEletronico>();
    private List<ManifestoCteNfe> nfe = new ArrayList<ManifestoCteNfe>();
    private List<ManifestoCteNfe1A> nfe1A = new ArrayList<ManifestoCteNfe1A>();
    private List<ItemNfeManualManifestoCteEletronico> nfeManual = new ArrayList<ItemNfeManualManifestoCteEletronico>();
    private Integer quantTotalCte = 0;
    private Integer quantTotalNfe = 0;
    private Integer quantTotalNfeMod1A = 0;
    private Double valorTotalCarga = 0.0;
    private Short codigoUnidadeMedida = 0;
    private Double pesoBrutoTotalCarga = 0.0;
    private UnidadeFederativa ufCarregamento;
    private UnidadeFederativa ufDescarregamento;
    private List<UnidadeFederativa> percurso;
    private List<ObservacaoEstNota> observacaoIntFisco = new ArrayList<ObservacaoEstNota>();
    private List<ObservacaoEstNota> observacaoComplementar = new ArrayList<ObservacaoEstNota>();
    private VersaoManifestoCte versaoManifestoCte;
    private PeriodoEmissaoManifestoCte periodoemissaoManifestoCte;
    private Short formatoImpressao = 0;
    private String numProtocolo;
    private String numProtocoloCancelamento;
    private String numProtocoloEncerramento;
    private Short status = 0;
    private String motivo;
    private LoteFaturamentoManifestoCte loteFaturamentoManifestoCte;
    private Short liberarDAMDFE = 0;
    private List<MDFeAutDownloadXML> mdfeAutDownloadXML = new ArrayList<MDFeAutDownloadXML>();
    private List<CIOTMDFe> cIOTMDFe = new ArrayList<CIOTMDFe>();
    private TipoTransportadorMDFe tipoTransportadorMDFe;
    private List<ManifestoCteSeguro> manifestoCteSeguro;
    private List<ManifestoCteContratante> manifestoCteContratante;
    private TransportadorAgregado transportadorAgregado;
    private Motorista motorista;
    private List<ManifestoCteVeiculo> manifestoCteVeiculo;
    private String qrCodMDFe;
    private ProdutoPredominanteCte produtoPredominante;
    private TipoCarga tipoCarga;
    private Short gerarAverbacao = 1;
    private List<AverbacaoCte> averbacaoCte;
    private ErroAverbacaoCte erroAverbacaoCte;
    private Short enviarManifestoAut = 1;
    private String numeroAverbacao;
    private Short aprovadoAverbacao = 0;
    private Short canceladoAverbacao = 0;
    private TipoModal modalCte;
    private MdfAquaviario mdfAquaviario;
    private CategoriaCombinacaoVeic categoriaCombinacaoVeic;
    private List<ManifestoCteInformacoesPagamentoFrete> manifestoCteInformacoesPagamentoFrete;

    public ManifestoCteEletronico() {
        this.percurso = new ArrayList<UnidadeFederativa>();
        this.manifestoCteSeguro = new ArrayList<ManifestoCteSeguro>();
        this.manifestoCteContratante = new ArrayList<ManifestoCteContratante>();
        this.manifestoCteVeiculo = new ArrayList<ManifestoCteVeiculo>();
        this.averbacaoCte = new ArrayList<AverbacaoCte>();
        this.manifestoCteInformacoesPagamentoFrete = new ArrayList<ManifestoCteInformacoesPagamentoFrete>();
    }

    @Id
    @Column(name="ID_MAN_CTE_ELETRONICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MAN_CTE_ELETRONICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
        if (empresa != null && empresa.getPessoa() != null && empresa.getPessoa().getComplemento() != null && empresa.getPessoa().getComplemento().getCnpj() != null) {
            this.setCnpj(empresa.getPessoa().getComplemento().getCnpj());
            this.setCodUF(Short.valueOf(empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge()));
        }
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CNPJ", length=18)
    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Column(name="CODIGO_UF")
    public Short getCodUF() {
        return this.codUF;
    }

    public void setCodUF(Short codUF) {
        this.codUF = codUF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO_MAN_CTE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_NAT_OP_MA"))
    public NaturezaOperacaoManifestoCte getNaturezaOperacaoManifestoCte() {
        return this.naturezaOperacaoManifestoCte;
    }

    public void setNaturezaOperacaoManifestoCte(NaturezaOperacaoManifestoCte naturezaOperacaoManifestoCte) {
        this.naturezaOperacaoManifestoCte = naturezaOperacaoManifestoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_MOD_DOC_F"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="NUMERO")
    @Generated(value=GenerationTime.ALWAYS)
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="HORA_SAIDA")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraSaida() {
        return this.horaSaida;
    }

    public void setHoraSaida(Date horaSaida) {
        this.horaSaida = horaSaida;
    }

    @Column(name="COD_CHAVE_ACESSO")
    public Integer getCodChaveAcesso() {
        return this.codChaveAcesso;
    }

    public void setCodChaveAcesso(Integer codChaveAcesso) {
        this.codChaveAcesso = codChaveAcesso;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DIGITO_VERIFICADOR")
    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        this.digitoVerificador = digitoVerificador;
    }

    @Generated(value=GenerationTime.INSERT)
    @Column(name="CHAVE_MANIFESTO_CTE", length=44)
    public String getChaveManifestoCte() {
        return this.chaveManifestoCte;
    }

    public void setChaveManifestoCte(String chaveManifestoCte) {
        this.chaveManifestoCte = chaveManifestoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETR_CONJ_TRA"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="MAN_CTE_RECARGA_VL_PEDAGIO", joinColumns={@JoinColumn(name="ID_MAN_CTE_ELETRONICO")}, inverseJoinColumns={@JoinColumn(name="ID_RECARGA_VALE_PEDAGIO")})
    public List<RecargaCartaoValePed> getValePedagio() {
        return this.valePedagio;
    }

    public void setValePedagio(List<RecargaCartaoValePed> valePedagio) {
        this.valePedagio = valePedagio;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteLacre> getManifestoCteLacre() {
        return this.manifestoCteLacre;
    }

    public void setManifestoCteLacre(List<ManifestoCteLacre> manifestoCteLacre) {
        this.manifestoCteLacre = manifestoCteLacre;
    }

    @Column(name="QUANTIDADE_TOTAL_CTE")
    public Integer getQuantTotalCte() {
        return this.quantTotalCte;
    }

    public void setQuantTotalCte(Integer quantTotalCte) {
        this.quantTotalCte = quantTotalCte;
    }

    @Column(name="QUANTIDADE_TOTAL_NFE")
    public Integer getQuantTotalNfe() {
        return this.quantTotalNfe;
    }

    public void setQuantTotalNfe(Integer quantTotalNfe) {
        this.quantTotalNfe = quantTotalNfe;
    }

    @Column(name="QUANTIDADE_TOTAL_NFE_1A")
    public Integer getQuantTotalNfeMod1A() {
        return this.quantTotalNfeMod1A;
    }

    public void setQuantTotalNfeMod1A(Integer quantTotalNfeMod1A) {
        this.quantTotalNfeMod1A = quantTotalNfeMod1A;
    }

    @Column(name="VALOR_TOTAL_CARGA", precision=13, scale=2)
    public Double getValorTotalCarga() {
        return this.valorTotalCarga;
    }

    public void setValorTotalCarga(Double valorTotalCarga) {
        this.valorTotalCarga = valorTotalCarga;
    }

    @Column(name="CODIGO_UNIDADE_MEDIDA")
    public Short getCodigoUnidadeMedida() {
        return this.codigoUnidadeMedida;
    }

    public void setCodigoUnidadeMedida(Short codigoUnidadeMedida) {
        this.codigoUnidadeMedida = codigoUnidadeMedida;
    }

    @Column(nullable=false, name="PESO_BRUTO_TOTAL_CARGA", precision=11, scale=4)
    public Double getPesoBrutoTotalCarga() {
        return this.pesoBrutoTotalCarga;
    }

    public void setPesoBrutoTotalCarga(Double pesoBrutoTotalCarga) {
        this.pesoBrutoTotalCarga = pesoBrutoTotalCarga;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CARREGAMENTO", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_UF_CARREG"))
    public UnidadeFederativa getUfCarregamento() {
        return this.ufCarregamento;
    }

    public void setUfCarregamento(UnidadeFederativa ufCarregamento) {
        this.ufCarregamento = ufCarregamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_DESCARREGAMENTO", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_UF_DESCA"))
    public UnidadeFederativa getUfDescarregamento() {
        return this.ufDescarregamento;
    }

    public void setUfDescarregamento(UnidadeFederativa ufDescarregamento) {
        this.ufDescarregamento = ufDescarregamento;
    }

    @OneToMany(targetEntity=UnidadeFederativa.class, fetch=FetchType.LAZY)
    @JoinTable(name="MANIFESTO_CTE_PERCURSO", joinColumns={@JoinColumn(name="ID_MANIFESTO_CTE_ELETRONICO")}, inverseJoinColumns={@JoinColumn(name="ID_UF")})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<UnidadeFederativa> getPercurso() {
        return this.percurso;
    }

    public void setPercurso(List<UnidadeFederativa> percurso) {
        this.percurso = percurso;
    }

    @OneToMany(targetEntity=ObservacaoEstNota.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="MAN_CTE_OBSERVACOES_INT_FISCO", joinColumns={@JoinColumn(name="ID_MAN_CTE_ELETRONICO")}, inverseJoinColumns={@JoinColumn(name="ID_OBSERVACAO_INT_FISCO")})
    public List<ObservacaoEstNota> getObservacaoIntFisco() {
        return this.observacaoIntFisco;
    }

    public void setObservacaoIntFisco(List<ObservacaoEstNota> observacaoIntFisco) {
        this.observacaoIntFisco = observacaoIntFisco;
    }

    @OneToMany(targetEntity=ObservacaoEstNota.class, cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="MAN_CTE_OBSERVACOES", joinColumns={@JoinColumn(name="ID_MAN_CTE_ELETRONICO")}, inverseJoinColumns={@JoinColumn(name="ID_OBSERVACAO_COMPLEMENTAR")})
    public List<ObservacaoEstNota> getObservacaoComplementar() {
        return this.observacaoComplementar;
    }

    public void setObservacaoComplementar(List<ObservacaoEstNota> observacaoComplementar) {
        this.observacaoComplementar = observacaoComplementar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VERSAO_MANIFESTO_CTE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_VER_MA_CT"))
    public VersaoManifestoCte getVersaoManifestoCte() {
        return this.versaoManifestoCte;
    }

    public void setVersaoManifestoCte(VersaoManifestoCte versaoManifestoCte) {
        this.versaoManifestoCte = versaoManifestoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_EMISSAO_MAN_CTE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_PER_EM_CT"))
    public PeriodoEmissaoManifestoCte getPeriodoemissaoManifestoCte() {
        return this.periodoemissaoManifestoCte;
    }

    public void setPeriodoemissaoManifestoCte(PeriodoEmissaoManifestoCte periodoemissaoManifestoCte) {
        this.periodoemissaoManifestoCte = periodoemissaoManifestoCte;
    }

    @Column(name="FORMATO_IMPRESSAO")
    public Short getFormatoImpressao() {
        return this.formatoImpressao;
    }

    public void setFormatoImpressao(Short formatoImpressao) {
        this.formatoImpressao = formatoImpressao;
    }

    @Column(name="NUMERO_PROTOCOLO", length=15)
    public String getNumProtocolo() {
        return this.numProtocolo;
    }

    public void setNumProtocolo(String numProtocolo) {
        this.numProtocolo = numProtocolo;
    }

    @Column(name="NUM_PROTOCOLO_CANCELAMENTO", length=15)
    public String getNumProtocoloCancelamento() {
        return this.numProtocoloCancelamento;
    }

    public void setNumProtocoloCancelamento(String numProtocoloCancelamento) {
        this.numProtocoloCancelamento = numProtocoloCancelamento;
    }

    @Column(name="NUM_PROTOCOLO_ENCERRAMENTO", length=15)
    public String getNumProtocoloEncerramento() {
        return this.numProtocoloEncerramento;
    }

    public void setNumProtocoloEncerramento(String numProtocoloEncerramento) {
        this.numProtocoloEncerramento = numProtocoloEncerramento;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FATURAMENTO_MAN_CTE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_LOTE_MAN"))
    public LoteFaturamentoManifestoCte getLoteFaturamentoManifestoCte() {
        return this.loteFaturamentoManifestoCte;
    }

    public void setLoteFaturamentoManifestoCte(LoteFaturamentoManifestoCte loteFaturamentoManifestoCte) {
        this.loteFaturamentoManifestoCte = loteFaturamentoManifestoCte;
    }

    @Column(name="LIBERAR_DAMDFE")
    public Short getLiberarDAMDFE() {
        return this.liberarDAMDFE;
    }

    public void setLiberarDAMDFE(Short liberarDAMDFE) {
        this.liberarDAMDFE = liberarDAMDFE;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getNumero() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumero()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemCteManualManifestoCteEletronico> getCteManual() {
        return this.cteManual;
    }

    public void setCteManual(List<ItemCteManualManifestoCteEletronico> cteManual) {
        this.cteManual = cteManual;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemNfeManualManifestoCteEletronico> getNfeManual() {
        return this.nfeManual;
    }

    public void setNfeManual(List<ItemNfeManualManifestoCteEletronico> nfeManual) {
        this.nfeManual = nfeManual;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<MDFeAutDownloadXML> getMdfeAutDownloadXML() {
        return this.mdfeAutDownloadXML;
    }

    public void setMdfeAutDownloadXML(List<MDFeAutDownloadXML> mdfeAutDownloadXML) {
        this.mdfeAutDownloadXML = mdfeAutDownloadXML;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteCte> getCte() {
        return this.cte;
    }

    public void setCte(List<ManifestoCteCte> cte) {
        this.cte = cte;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteNfe> getNfe() {
        return this.nfe;
    }

    public void setNfe(List<ManifestoCteNfe> nfe) {
        this.nfe = nfe;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteNfe1A> getNfe1A() {
        return this.nfe1A;
    }

    public void setNfe1A(List<ManifestoCteNfe1A> nfe1A) {
        this.nfe1A = nfe1A;
    }

    @OneToMany(mappedBy="manifestoCteEletronico")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CIOTMDFe> getcIOTMDFe() {
        return this.cIOTMDFe;
    }

    public void setcIOTMDFe(List<CIOTMDFe> cIOTMDFe) {
        this.cIOTMDFe = cIOTMDFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_TRANSPORTADOR_MDFE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELET_TP_TR_MDFE"))
    public TipoTransportadorMDFe getTipoTransportadorMDFe() {
        return this.tipoTransportadorMDFe;
    }

    public void setTipoTransportadorMDFe(TipoTransportadorMDFe tipoTransportadorMDFe) {
        this.tipoTransportadorMDFe = tipoTransportadorMDFe;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteSeguro> getManifestoCteSeguro() {
        return this.manifestoCteSeguro;
    }

    public void setManifestoCteSeguro(List<ManifestoCteSeguro> manifestoCteSeguro) {
        this.manifestoCteSeguro = manifestoCteSeguro;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteContratante> getManifestoCteContratante() {
        return this.manifestoCteContratante;
    }

    public void setManifestoCteContratante(List<ManifestoCteContratante> manifestoCteContratante) {
        this.manifestoCteContratante = manifestoCteContratante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_AGREGADO", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELET_TRANSP_AGREG"))
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELET_MOTORISTA"))
    public Motorista getMotorista() {
        return this.motorista;
    }

    public void setMotorista(Motorista motorista) {
        this.motorista = motorista;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ManifestoCteVeiculo> getManifestoCteVeiculo() {
        return this.manifestoCteVeiculo;
    }

    public void setManifestoCteVeiculo(List<ManifestoCteVeiculo> manifestoCteVeiculo) {
        this.manifestoCteVeiculo = manifestoCteVeiculo;
    }

    @Column(name="QR_CODE_MDFE", length=500)
    public String getQrCodMDFe() {
        return this.qrCodMDFe;
    }

    public void setQrCodMDFe(String qrCodMDFe) {
        this.qrCodMDFe = qrCodMDFe;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_PREDOMINANTE", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_PROD_PRED"))
    public ProdutoPredominanteCte getProdutoPredominante() {
        return this.produtoPredominante;
    }

    public void setProdutoPredominante(ProdutoPredominanteCte produtoPredominante) {
        this.produtoPredominante = produtoPredominante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CARGA", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_TIPO_CARG"))
    public TipoCarga getTipoCarga() {
        return this.tipoCarga;
    }

    public void setTipoCarga(TipoCarga tipoCarga) {
        this.tipoCarga = tipoCarga;
    }

    @Column(name="GERAR_AVERBACAO")
    public Short getGerarAverbacao() {
        return this.gerarAverbacao;
    }

    public void setGerarAverbacao(Short gerarAverbacao) {
        this.gerarAverbacao = gerarAverbacao;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    public List<AverbacaoCte> getAverbacaoCte() {
        return this.averbacaoCte;
    }

    public void setAverbacaoCte(List<AverbacaoCte> averbacaoCte) {
        this.averbacaoCte = averbacaoCte;
    }

    @OneToOne(mappedBy="manifestoCteEletronico", fetch=FetchType.LAZY)
    public ErroAverbacaoCte getErroAverbacaoCte() {
        return this.erroAverbacaoCte;
    }

    public void setErroAverbacaoCte(ErroAverbacaoCte erroAverbacaoCte) {
        this.erroAverbacaoCte = erroAverbacaoCte;
    }

    @Column(name="ENVIAR_MANIFESTO_AUT")
    public Short getEnviarManifestoAut() {
        return this.enviarManifestoAut;
    }

    public void setEnviarManifestoAut(Short enviarManifestoAut) {
        this.enviarManifestoAut = enviarManifestoAut;
    }

    @Column(name="NUMERO_AVERBACAO", length=100)
    public String getNumeroAverbacao() {
        return this.numeroAverbacao;
    }

    public void setNumeroAverbacao(String numeroAverbacao) {
        this.numeroAverbacao = numeroAverbacao;
    }

    @Column(name="APROVADO_AVERBACAO")
    public Short getAprovadoAverbacao() {
        return this.aprovadoAverbacao;
    }

    public void setAprovadoAverbacao(Short aprovadoAverbacao) {
        this.aprovadoAverbacao = aprovadoAverbacao;
    }

    @Column(name="CANCELADO_AVERBACAO")
    public Short getCanceladoAverbacao() {
        return this.canceladoAverbacao;
    }

    public void setCanceladoAverbacao(Short canceladoAverbacao) {
        this.canceladoAverbacao = canceladoAverbacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MODAL", foreignKey=@ForeignKey(name="FK_CTE_TIPO_MODAL"))
    public TipoModal getModalCte() {
        return this.modalCte;
    }

    public void setModalCte(TipoModal modalCte) {
        this.modalCte = modalCte;
    }

    @OneToOne(mappedBy="manifestoCteEletronico", cascade={CascadeType.ALL}, orphanRemoval=true)
    public MdfAquaviario getMdfAquaviario() {
        return this.mdfAquaviario;
    }

    public void setMdfAquaviario(MdfAquaviario mdfAquaviario) {
        this.mdfAquaviario = mdfAquaviario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_COMBINACAO_VEIC", foreignKey=@ForeignKey(name="FK_MAN_CTE_ELETRONICO_CAT_CO_VE"))
    public CategoriaCombinacaoVeic getCategoriaCombinacaoVeic() {
        return this.categoriaCombinacaoVeic;
    }

    public void setCategoriaCombinacaoVeic(CategoriaCombinacaoVeic categoriaCombinacaoVeic) {
        this.categoriaCombinacaoVeic = categoriaCombinacaoVeic;
    }

    @OneToMany(mappedBy="manifestoCteEletronico", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ManifestoCteInformacoesPagamentoFrete> getManifestoCteInformacoesPagamentoFrete() {
        return this.manifestoCteInformacoesPagamentoFrete;
    }

    public void setManifestoCteInformacoesPagamentoFrete(List<ManifestoCteInformacoesPagamentoFrete> manifestoCteInformacoesPagamentoFrete) {
        this.manifestoCteInformacoesPagamentoFrete = manifestoCteInformacoesPagamentoFrete;
    }
}

