/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdiantamento;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAltercaoValoresAdd;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MANUTENCAO_VAL_PERC_ADD_SALARIO")
public class ManutencaoValoresPercAddSalario
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataAlteracao;
    private Short tipoAlteracao = EnumConstTipoAdiantamento.ADIANTAMENTO_POR_VALOR.getEnumId();
    private Double percValor = 0.0;
    private String descricao;
    private List<ItemAltercaoValoresAdd> itensAlteracao = new ArrayList<ItemAltercaoValoresAdd>();
    private Short tipoArrendondamento = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_MANUTENC_VAL_PERC_ADD_SAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MANUTENC_VAL_PERC_ADD_SAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MANUT_VAL_PERC_ADD_SAL_EMPRE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_ALTERACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(Date dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Column(name="TIPO_ALTERACAO")
    public Short getTipoAlteracao() {
        return this.tipoAlteracao;
    }

    public void setTipoAlteracao(Short tipoAlteracao) {
        this.tipoAlteracao = tipoAlteracao;
    }

    @Column(name="PERC_VALOR", precision=15, scale=2)
    public Double getPercValor() {
        return this.percValor;
    }

    public void setPercValor(Double percValor) {
        this.percValor = percValor;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="manutencaoAdiantamento", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemAltercaoValoresAdd> getItensAlteracao() {
        return this.itensAlteracao;
    }

    public void setItensAlteracao(List<ItemAltercaoValoresAdd> itensAlteracao) {
        this.itensAlteracao = itensAlteracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_ARREDONDAMENTO")
    public Short getTipoArrendondamento() {
        return this.tipoArrendondamento;
    }

    public void setTipoArrendondamento(Short tipoArrendondamento) {
        this.tipoArrendondamento = tipoArrendondamento;
    }
}

