/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.cte.aquaviario.EnumConstTipoNavegacao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Embarcacao;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.MdfComboio;
import com.touchcomp.basementor.model.vo.MdfTerminalCarregamento;
import com.touchcomp.basementor.model.vo.MdfTerminalDescarregamento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MDF_AQUAVIARIO")
public class MdfAquaviario
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_MDF_AQUAVIARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MDF_AQUAVIARIO")
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MAN_CTE_ELETRONICO", foreignKey=@ForeignKey(name="FK_CTE_AQUAVIARIO_CTE"))
    private ManifestoCteEletronico manifestoCteEletronico;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBARCACAO", foreignKey=@ForeignKey(name="FK_CTE_AQUAVIARIO_EMBARCACAO"))
    private Embarcacao navio;
    @Column(name="NUMERO_VIAGEM")
    private Integer numeroViagem = 0;
    @Column(name="PORTO_EMBARQUE", length=5)
    private String portoEmbarque;
    @Column(name="PORTO_DESEMBARQUE", length=5)
    private String portoDesembarque;
    @Column(name="PORTO_TRANSBORDO", length=60)
    private String portoTransbordo;
    @Column(name="TIPO_NAVEGACAO")
    private Short tipoNavegacao = EnumConstTipoNavegacao.TIPO_NAVEGACAO_INTERIOR.getEnumId();
    @OneToMany(mappedBy="mdfAquaviario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<MdfTerminalCarregamento> terminaisCarregamento = new ArrayList<MdfTerminalCarregamento>();
    @OneToMany(mappedBy="mdfAquaviario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<MdfTerminalDescarregamento> terminaisDescarregamento = new ArrayList<MdfTerminalDescarregamento>();
    @OneToMany(mappedBy="mdfAquaviario", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<MdfComboio> embarcacoesComboio = new ArrayList<MdfComboio>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public ManifestoCteEletronico getManifestoCteEletronico() {
        return this.manifestoCteEletronico;
    }

    @Generated
    public Embarcacao getNavio() {
        return this.navio;
    }

    @Generated
    public Integer getNumeroViagem() {
        return this.numeroViagem;
    }

    @Generated
    public String getPortoEmbarque() {
        return this.portoEmbarque;
    }

    @Generated
    public String getPortoDesembarque() {
        return this.portoDesembarque;
    }

    @Generated
    public String getPortoTransbordo() {
        return this.portoTransbordo;
    }

    @Generated
    public Short getTipoNavegacao() {
        return this.tipoNavegacao;
    }

    @Generated
    public List<MdfTerminalCarregamento> getTerminaisCarregamento() {
        return this.terminaisCarregamento;
    }

    @Generated
    public List<MdfTerminalDescarregamento> getTerminaisDescarregamento() {
        return this.terminaisDescarregamento;
    }

    @Generated
    public List<MdfComboio> getEmbarcacoesComboio() {
        return this.embarcacoesComboio;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setManifestoCteEletronico(ManifestoCteEletronico manifestoCteEletronico) {
        this.manifestoCteEletronico = manifestoCteEletronico;
    }

    @Generated
    public void setNavio(Embarcacao navio) {
        this.navio = navio;
    }

    @Generated
    public void setNumeroViagem(Integer numeroViagem) {
        this.numeroViagem = numeroViagem;
    }

    @Generated
    public void setPortoEmbarque(String portoEmbarque) {
        this.portoEmbarque = portoEmbarque;
    }

    @Generated
    public void setPortoDesembarque(String portoDesembarque) {
        this.portoDesembarque = portoDesembarque;
    }

    @Generated
    public void setPortoTransbordo(String portoTransbordo) {
        this.portoTransbordo = portoTransbordo;
    }

    @Generated
    public void setTipoNavegacao(Short tipoNavegacao) {
        this.tipoNavegacao = tipoNavegacao;
    }

    @Generated
    public void setTerminaisCarregamento(List<MdfTerminalCarregamento> terminaisCarregamento) {
        this.terminaisCarregamento = terminaisCarregamento;
    }

    @Generated
    public void setTerminaisDescarregamento(List<MdfTerminalDescarregamento> terminaisDescarregamento) {
        this.terminaisDescarregamento = terminaisDescarregamento;
    }

    @Generated
    public void setEmbarcacoesComboio(List<MdfComboio> embarcacoesComboio) {
        this.embarcacoesComboio = embarcacoesComboio;
    }
}

