/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="MEDIA_RECISAO_COLABORADOR")
public class MediaRecisaoColaborador
implements InterfaceVO {
    private Long identificador;
    private TipoCalculoEvento tipoCalculoEvento;
    private Recisao recisao;
    private Double referencia = 0.0;
    private Double valor = 0.0;
    private Short informarValor = 0;
    private Short tipoEvento = 0;
    private Double valorOriginal = 0.0;
    private Short tipoMedia = EnumConstEventoMedias.MEDIA_REFERENCIA.getValue();
    private Recisao recisaoV;
    private Short tipoRemuneracao = EnumConstEventoMedias.MEDIA_REFERENCIA.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_MEDIAS_RECISAO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECISAO_MEDIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_MEDIA_RECISAO_COLAB_TP_CALC"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento evento) {
        this.tipoCalculoEvento = evento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECISAO", foreignKey=@ForeignKey(name="FK_MEDIA_RECISAO_COLAB_RESCISAO"))
    public Recisao getRecisao() {
        return this.recisao;
    }

    public void setRecisao(Recisao recisao) {
        this.recisao = recisao;
    }

    @Column(name="REFERENCIA", precision=15, scale=4)
    public Double getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Double referencia) {
        this.referencia = referencia;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=4)
    public Double getValor() {
        this.valor = this.valor == null || this.valor < 0.0 ? 0.0 : this.valor;
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="INFORMAR_VALOR")
    public Short getInformarValor() {
        return this.informarValor;
    }

    public void setInformarValor(Short informarValor) {
        this.informarValor = informarValor;
    }

    @Column(name="TIPO_EVENTO")
    public Short getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(Short tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR_ORIGINAL", precision=15, scale=4)
    public Double getValorOriginal() {
        return this.valorOriginal;
    }

    public void setValorOriginal(Double valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Column(name="TIPO_MEDIA")
    public Short getTipoMedia() {
        return this.tipoMedia;
    }

    public void setTipoMedia(Short tipoMedia) {
        this.tipoMedia = tipoMedia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECISAO_V", foreignKey=@ForeignKey(name="FK_MEDIA_RECISAO_COLAB_REC_V"))
    public Recisao getRecisaoV() {
        return this.recisaoV;
    }

    public void setRecisaoV(Recisao recisaoV) {
        this.recisaoV = recisaoV;
    }

    @Column(name="TIPO_REMUNERACAO")
    public Short getTipoRemuneracao() {
        return this.tipoRemuneracao;
    }

    public void setTipoRemuneracao(Short tipoRemuneracao) {
        this.tipoRemuneracao = tipoRemuneracao;
    }
}

